(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información relevante sobre la conexión Wide Area Network (Internet)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La dirección física única asignada al puerto de Internet (WAN) del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IP asignada al puerto de Internet (WAN) del router. Si la dirección IP se muestra como 0.0.0.0, esto indica que no hay acceso a Internet."
                }, {
                    type: "name",
                    title: "Máscara de Subred",
                    content: "Este parámetro determina la porción de red y la porción de equipo de una dirección IP."
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "La dirección IP utilizada para conectar el router a la red."
                }, {
                    type: "name",
                    title: "DNS Primario/DNS Secundario",
                    content: "El Sistema de Nombres de Dominio (DNS) traduce los nombres de los equipos y los dominios de Internet a direcciones IP. La información de esos servidores DNS es asignada por el Proveedor del Servicio de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "El tipo de conexión actual del puerto de Internet (WAN)."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La única dirección física asignada al puerto de Internet (WAN) del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IP asignada al puerto de Internet (WAN) del router."
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "La dirección IP utilizada para conectar el router a la red."
                }, {
                    type: "name",
                    title: "DNS Primario/DNS Secundario",
                    content: "El Sistema de Nombres de Dominio (DNS) traduce los nombres de los hosts y los dominios de Internet a direcciones IP. La información de esos servidores DNS es asignada por el Proveedor del Servicio de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "El tipo de conexión actual del puerto de Internet (WAN)."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Red Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Pulse en el icono de la Red Powerline para mostrar la lista de todos los dispositivos powerline en la red powerline actual."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Pulse el icono Powerline para mostrar información detallada sobre el extensor powerline local."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "El identificador único que es asignado al extensor powerline local."
                }, {
                    type: "name",
                    title: "Clave Powerline",
                    content: "La clave única del dispositivo powerline que es utilizada cuando es añadido a la red powerline. La clave también está impresa en la etiqueta del producto."
                }, {
                    type: "name",
                    title: "Nombre de Red",
                    content: "El nombre de la red en la que se encuentra el extensor powerline. Por defecto es HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "Red Inalámbrica 2.4GHz<span class=\"anti_5g\">/5GHz</span>",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra el estado y la información básica de la Red Inalámbrica."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "El estado actual (Encendido o Apagado) de su Red Inalámbrica."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "El Identificador de Servicio, también conocido como nombre de red inalámbrica."
                }, {
                    type: "name",
                    title: "Canal ",
                    content: "El canal inalámbrico actual."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "La dirección MAC inalámbrica del extensor powerline."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información sobre los puertos Ethernet (LAN)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La dirección física asiganda al puerto Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IPv4 asignada la puerto Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Máscara de Subred",
                    content: "Este parámetro determina la porción de red y la porción de equipo de una dirección IP."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Muestra si el servidor DHCP del router está activo para los dispositivos de los puertos LAN o no."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La dirección física única asignada al puerto Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "La dirección IPv6 asignada al puerto de Internet (LAN) del router."
                }, {
                    type: "name",
                    title: "Dirección de Enlace Local",
                    content: "La dirección de enlace IPv6 para la interfaz LAN."
                }, {
                    type: "name",
                    title: "Tipo Asignado",
                    content: "El tipo de dirección IPv6 para la interfaz LAN."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "Red de Invitados 2.4GHz<span class=\"anti_5g\">/5GHz</span>",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la información sobre la red inalámbrica para los invitados."
                }, {
                    type: "name",
                    title: "Estado ",
                    content: "El estado actual (Encendido o Apagado) de su Red de Invitados."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "El nombre de la red inalámbrica de su Red de Invitados."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "Dispositivos USB",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra información de los dispositivos de almacenamiento USB y/o de las impresoras conectadas al router a través de los puertos USB."
                }, {
                    type: "name",
                    title: "Impresora",
                    content: "El nombre de la impresora conectada."
                }, {
                    type: "name",
                    title: "Total",
                    content: "La capacidad de almacenamiento total del dispositivo de almacenamiento USB conectado."
                }, {
                    type: "name",
                    title: "Disponible",
                    content: "La capacidad de almacenamiento disponible del dispositivo de almacenamiento USB conectado."
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Rendimiento",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra el rendimiento actual del router."
                }, {
                    type: "name",
                    title: "Carga de CPU",
                    content: "El uso actual de la CPU."
                }, {
                    type: "name",
                    title: "Memoria Usada",
                    content: "El uso actual de la memoria."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Clientes Cableados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra información de todos los dispositivos cableados que están conectados en la red."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Clientes Inalámbricos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Pulse el icono de Clientes Inalámbricos para mostrar toda la información de los dispositivos inalámbricos que que están conectados actualmente a la red inalámbrica creada por el extensor powerline."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La dirección MAC del cliente inalámbrico."
                }, {
                    type: "name",
                    title: "Banda Inalámbrica",
                    content: "La banda Wi-Fi  <span class=\"anti_5g\">(2.4GHz o 5GHz) </span> a la que el cliente está conectado."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indica si la función Wi-Fi Move está habilitada o no."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Tipo de Conexión a Internet: IP Estática"
                }, {
                    type: "paragraph",
                    content: "Seleccione este tipo si su ISP le proporciona una dirección IP específica (fija), Máscara de Subred, Puerta de Enlace y parámetros DNS."
                }, {
                    type: "name",
                    title: "Dirección IP/Máscara de Subred/Puerta de Enlace Predeterminada/DNS Primario/DNS Secundario",
                    content: "Introduzca la información proporcionada por su ISP."
                }, {
                    type: "name",
                    title: "Tamaño MTU",
                    content: "El tamaño típico y por defecto de MTU (Unidad Máxima de Transmisión) para la mayoría de redes Ethernet es 1500 Bytes. NO es recomendable cambiar el tamaño MTU por defecto a menos que el ISP lo requiera."
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: IP Dinámica"
                }, {
                    type: "paragraph",
                    content: "Seleccione este tipo si su ISP (Proveedor de Servicio de Internet) le proporciona conexión con un servidor DHCP."
                }, {
                    type: "name",
                    title: "Dirección IP/Máscara de Subred/Puerta de Enlace Predeterminada/DNS Primario/DNS Secundario",
                    content: "Estos parámetros son asignados automáticamente por el servidor DHCP de su ISP."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Pulse este botón para obtener unos nuevos parámetros de IP desde el servidor DHCP."
                }, {
                    type: "name",
                    title: "Liberar",
                    content: "Pulse este botón para liberar todas las direcciones IP asignadas por el servidor DHCP."
                }, {
                    type: "name",
                    title: "Utilizar las siguientes direcciones de DNS",
                    content: "Si el ISP proporciona una o dos direcciones DNS, seleccione esta casilla e introduzca las direcciones de DNS Primario y DNS Secundario en los correspondientes campos; de otra manera, las direcciones DNS serán asignadas dinámicamente por el ISP."
                }, {
                    type: "name",
                    title: "Tamaño MTU",
                    content: "El tamaño típico y por defecto de MTU (Unidad Máxima de Transmisión) para la mayoría de redes Ethernet es 1500 Bytes. NO es recomendable cambiar el tamaño MTU por defecto a menos que el ISP lo requiera."
                }, {
                    type: "name",
                    title: "Nombre de Equipo",
                    content: "Introduzca un valor en este campo para especificar el nombre del router."
                }, {
                    type: "name",
                    title: "Obtener IP usando DHCP Unicast",
                    content: "Seleccione esta casilla si el servidor DHCP de su ISP no soporta aplicaciones broadcast y no puede obtener la dirección IP dinámicamente."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si encuentra errores de \"Dirección no encontrada\" después de introducir las direcciones DNS, es posible que los servidores DNS estén configurados incorrectamente; contacte con su ISP para que puedan ayudarle."
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Seleccione este tipo su utiliza servicio DSL (Línea de Suscripción Digital) y su ISP le proporciona un nombre de usuario y contraseña."
                }, {
                    type: "name",
                    title: "Usuario/Contraseña",
                    content: "Introduzca el nombre de usuario y contraseña proporcionada por el ISP. Realice un uso correcto de las mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Dirección IP Internet/DNS Primario/DNS Secundario",
                    content: "Estos parámetros son asignados automáticamente por el servidor DHCP de su ISP."
                }, {
                    type: "name",
                    title: "Conexión Secundaria (Ninguna, IP Dinámica, IP Estática)",
                    children: [
                        {
                            type: "name",
                            title: "Ninguna",
                            content: "Seleccione si no le proporcionan ninguna conexión secundaria."
                        }, {
                            type: "name",
                            title: "IP Dinámica",
                            content: "Seleccione si la dirección IP y la Máscara de Subred están asignadas automáticamente por el ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Pulse este botón para renovar los parámetros IP de su ISP."
                                }, {
                                    type: "name",
                                    title: "Liberar",
                                    content: "Pulse este botón para liberar los parámetros IP asignados."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estática",
                            content: "Seleccione si la dirección IP, la Máscara de Subred, la Puerta de Enlace y las direcciones DNS están proporcionadas por el ISP e introduzca esa información en los campos correspondientes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Tamaño MTU",
                    content: "El tamaño típico de MTU (Unidad de Transmisión Máxima) para las redes Ethernet es 1480 Bytes.",
                    children: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "En algún caso raro, su ISP puede requerirle ajustar el tamño MTU para un mejor rendimiento de la red. No debe cambiar el valor a menos que sea absolutamente necesario."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Nombre de Servicio/ Nombre de Acceso del Concentrador",
                    content: "Por defecto, el nombre de Servico y el Nombre de Acceso del Concentrador (AC) se deben dejar en blanco. Estos campos no deben ser configurados a menos que su ISP se lo requiera."
                }, {
                    type: "name",
                    title: "Intervalo de Detección Online",
                    content: "Introduzca un valor de intervalo de tiempo entre 0 y 120 (en segundos) en el cual el router detecte el Concentrador de Acceso online en todo el intervalo. Por defecto, el valor es 0, lo que significa que no existe detección."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Si su ISP proporciona una dirección IP específica (fija), seleccione Utilizar la siguiente dirección IP e introduzca la dirección IP en el campo; si no seleccione Obtener Dinámicamente desde el ISP para obtener una dirección IP asignada por el servidor."
                }, {
                    type: "name",
                    title: "Dirección DNS/DNS Primario/DNS Secundario",
                    content: "Si su ISP le proporciona direcciones IP de DNS específicas (fijas), seleccione Utilizar la siguiente Dirección DNS e introduzca la/s dirección/es en los campos DNS Primario y DNS Secundario respectivamente; si no seleccione Obtener Dinámicamente desde el ISP para obtener la dirección/es IP de DNS asignada/s por el servidor automáticamente."
                }, {
                    type: "name",
                    title: "Modo de Conexión",
                    content: "Seleccione el modo de conexión apropiado que determina cómo conectar a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "En este modo, la conexión a Internet reconecta automáticamente cada vez que hay una desconexión."
                        }, {
                            type: "name",
                            title: "Bajo Demanda",
                            content: "En este modo, la conexión a Internet terminará automáticamente después de que pase un tiempo específico de inactividad (Max Idle Time). La conexión se reestablece cuando hay un nuevo intento de acceso a Internet."
                        }, {
                            type: "name",
                            title: "Basado en Tiempo",
                            content: "En este modo, la conexión a Internet solamente se establece en un periodo de tiempo específico. Si esta opción está seleccionada, introduzca la hora de inicio y la hora final; ambas deben estar en formato HH:MM."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "En este modo, la conexión a Internet se controla manualmente haciendo clic en el botón Conectar o Desconectar. Este modo también admite la función Max Idle Time. Introduzca un tiempo máximo (en minutos) la conexión a Internet puede estar inactiva antes de que termine en el campo Tiempo de inactividad máximo. El valor predeterminado es de minutos. Si desea que la conexión a Internet permanezca activa en todo momento, introduzca 0 (cero)."
                        }, {
                            type: "note",
                            title: "Nota",
                            content: "El modo de conexión Basado en Tiempo solamente tomará efecto una vez que la Hora del Sistema en el menú Avanzado → Herramientas del Sistema → Ajustes de Hora esté configurada."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: Cable BigPond"
                }, {
                    type: "paragraph",
                    content: "Seleccione este tipo si su ISP le proporciona conexión Cable BigPond."
                }, {
                    type: "name",
                    title: "Usuario/Contraseña",
                    content: "Introduzca el usuario y contraseña porporcionados por su ISP. Haga un uso correcto de las mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Servidor de Autenticación",
                    content: "Introduzca la dirección IP del servidor de autenticación o nombre de equipo."
                }, {
                    type: "name",
                    title: "Dominio de Autenticación",
                    content: "Introduzca el sufijo del nombre de dominio del servidor (basado en su localcización). Por ejemplo, nsw.bigpond.net.au para NSW/ACT, vic.bigpond.net.au for VIC/TAS/WA/SA/NT, o qld.bigpond.net.au para QLD."
                }, {
                    type: "name",
                    title: "Tamaño MTU",
                    content: "El tamaño típico por defecto de MTU (Unidad de Transmisión Máxima) para la mayoría de redes Ethernet es 1500 Bytes. NO se recomienda cambiar el valor por defecto de MTU a menos que se lo requiera el ISP."
                }, {
                    type: "name",
                    title: "Modo de Conexión",
                    content: "Seleccione un modo apropiado de conexión que determine cómo conectar a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "En este modo, la conexión a Internet se reconecta automáticamente cada vez que se desconecta."
                        }, {
                            type: "name",
                            title: "Bajo Demanda",
                            content: "En este modo, la conexión a Internet terminará automáticamente después de que pase un tiempo específico de inactividad (Max Idle Time). La conexión se reestablece cuando hay un nuevo intento de acceso a Internet."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "En este modo, la conexión a Internet se controla manualmente haciendo clic en el botón Conectar o Desconectar. Este modo también admite la función Max Idle Time. Introduzca un tiempo máximo (en minutos) la conexión a Internet puede estar inactiva antes de que termine en el campo Tiempo de inactividad máximo. El valor predeterminado es 15 minutos. Si desea que la conexión a Internet permanezca activa en todo momento, introduzca 0 (cero)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Seleccione este tipo si se conecta a un servidor VPN L2TP / PPTP y se le proporciona un nombre de usuario, contraseña y dirección IP / nombre de dominio del servidor por el ISP."
                }, {
                    type: "name",
                    title: "Usuario/Contraseña",
                    content: "Introduzca el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Dirección IP Internet/DNS Primario/DNS Secundario",
                    content: "Estos parámetros serán asignados automáticamente por el servidor DHCP de su ISP."
                }, {
                    type: "name",
                    title: "Conexión Secundaria (Ninguna, IP Dinámica, IP Estática)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinámica",
                            content: "Seleccione si la dirección IP y la Máscara de Subred están asignadas automáticamente por el ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Pulse este botón para renovar los parámetros IP de su ISP."
                                }, {
                                    type: "name",
                                    title: "Liberar",
                                    content: "Pulse este botón para liberar los parámetros IP asignados."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estática",
                            content: "Seleccione si la dirección IP, la Máscara de Subred, Puerta de Enlace y direcciones DNS están proporcionadas por el ISP e introduzca esa información en los campos correspondientes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP del Servidor VPN/ Nombre de Dominio",
                    content: "Introduzca la dirección IP o el nombre de dominio del servidor VPN proporcionado por su ISP."
                }, {
                    type: "name",
                    title: "Tamaño MTU",
                    content: "El tamaño típico por defecto de MTU (Unidad de Transmisión Máxima) para la mayoría de redes Ethernet es 1500 Bytes. NO se recomienda cambiar el valor por defecto de MTU a menos que se lo requiera el ISP."
                }, {
                    type: "name",
                    title: "Modo de Conexión",
                    content: "Seleccione el modo de conexión apropiado que determina cómo conectar a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "En este modo, la conexión a Internet se reconecta automáticamente cada vez que se desconecta."
                        }, {
                            type: "name",
                            title: "Bajo Demanda",
                            content: "En este modo, la conexión a Internet terminará automáticamente después de que pase un tiempo específico de inactividad (Max Idle Time). La conexión se reestablece cuando hay un nuevo intento de acceso a Internet."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "En este modo, la conexión a Internet se controla manualmente haciendo clic en el botón Conectar o Desconectar. Este modo también admite la función Max Idle Time. Introduzca un tiempo máximo (en minutos) la conexión a Internet puede estar inactiva antes de que termine en el campo Tiempo de inactividad máximo. El valor predeterminado es 15 minutos. Si desea que la conexión a Internet permanezca activa en todo momento, introduzca 0 (cero)."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Lista de Dispositivos Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra información de todos los dispositivos pertenecientes a la misma red situados en el mismo circuito eléctrico."
                }, {
                    type: "name",
                    title: "Dispositivo Local",
                    content: "El extensor powerline en el que está actualmente registrado."
                }, {
                    type: "step",
                    content: ["En la lista de dispositivos powerline, las direcciones MAC y la velocidad de los datos transmitidos del dispositivo correspondiente son mostrados de izquierda a derecha.", "Pulse el icono <b>Papelera</b> para borrar el dispositivo powerline correspondiente de esta red.", "Pulse el icono <b>Más</b> para añadir un nuexo extensor powerline utilizando su contraseña para la red powerline."]
                }, {
                    type: "name",
                    title: "Atrás",
                    content: "Pulse para ir atrás al menú Status."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Pulse para actualizar la página."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "Clonado MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Utilizar Dirección MAC por Defecto",
                    content: "NO cambie la dirección MAC predeterminada del router, en caso de que el ISP no vincule la dirección IP asignada a la dirección MAC."
                }, {
                    type: "name",
                    title: "Utilizar Dirección MAC del Ordenador Actual",
                    content: "Seleccione para copiar la dirección MAC actual del equipo que está conectado al router, en caso de que el ISP vincule la dirección IP asignada a la dirección MAC del equipo."
                }, {
                    type: "name",
                    title: "Utilizar Dirección MAC Personalizada",
                    content: "Introduzca la dirección MAC manualmente, en caso de que el ISP vincule la dirección IP asignada a la dirección MAC específica."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "Ajustes LAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo de LAN",
                    content: "Seleccione IP Dinámica o IP Estática."
                }, {
                    type: "name",
                    title: "IP Dinámica",
                    content: "Seleccione esta opción para obtener automáticamente una dirección IP desde el servidor DHCP."
                }, {
                    type: "name",
                    title: "IP Estática",
                    content: "Seleccione esta opción para especificar manualmente la dirección IP, máscara de subred y puerta de enlace predeterminada."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP por defecto del extensor, la cual es utilizada para acceder a la página web de gestión del extensor y puede ser sobreescrita."
                }, {
                    type: "name",
                    title: "Máscara de Subred",
                    content: "Seleccione un identificador utilizado por el puerto LAN para enrutar el tráfico Interno y Externo de la lista desplegable o introducir una nueva máscara de subred en formato decimal."
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "La dirección IP utilizada para conectar el extensor a la red."
                }, {
                    type: "paragraph",
                    content: "Pulse <b>Guardar</b> para guardar todos los ajustes."
                }
            ]
        },
        LED_TIME: {
            TITLE: "Programación LED",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Programación LED le permite Encender (o Apagar) los LEDs en este extensor powerlinede acuerdo a un calendario específico."
                }, {
                    type: "name",
                    title: "Programación LED",
                    content: "Pulse <b>On</b> para habilitar la función Programación LED."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Programación Apagado LED",
            CONTENT: [
                {
                    type: "name",
                    title: "Desde",
                    content: "Muestra la hora en la que el LED se Apaga."
                }, {
                    type: "name",
                    title: "Hasta",
                    content: "Muestra la hora en la que el LED se Enciende de nuevo."
                }, {
                    type: "name",
                    title: "Día(s)",
                    content: "Muestra los días en los que el calendario es efectivo."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Indica el estado actual de la programación correspondiente. Pulse el icono <b>Bombilla</b> para habilitar (o deshabilitar) el calendario."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para <b>Modificar</b> o <b>Borrar</b> la programación correspondiente."
                }, {
                    type: "step",
                    title: "Para crear una nueva programación",
                    content: ["1. Pulse <b>Añadir</b>.", "2. Especifique el rango de tiempo durante el cual el LED estará apagado.", "3. Seleccione los días de la semana cuando se hará efectiva la programación.", "4. Seleccione <b>Habilitar esta entrada</b>.", "5. Pulse <b>OK</b> para guardar los ajustes."]
                }, {
                    type: "paragraph",
                    content: "Para modificar o borrar una programación, simplemente pulse el icono <b>Papelera</b> para borrar la programación correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para eliminar múltiples programaciones, seleccione la casilla correspondiente de las que desee eliminar y pulse <b>Eliminar<b> debajo de la tabla."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "Dirección MAC",
                    content: "La dirección física única asignada al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Clave Powerline",
                    content: "La clave única del dispositivo powerline utilizada cuando es añadido a la red powerline. La clave también está impresa en la etiqueta del producto."
                }, {
                    type: "name",
                    title: "Nombre de Red",
                    content: "Muestra el nombre de la red powerline a la que pertenece el dispositivo extensor powerline. Puedes renombrar la red aquí o pulsar Predeterminado para resetear el nombre al valor por defecto, por ejemplo HomePlugAV. Por favor, tenga en cuenta que si el nombre predeterminado está siendo utilizado, la funcionalidad Wi-Fi Move se dehabilitará automáticamente. "
                }
            ]
        },
        IPTV: {
            TITLE: "Ajustes",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "Seleccione para habilitar la funcionalidad IPTV."
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccione el modo apropiado de acuerdo con su ISP. Hay seis tipos de modos IPTV:",
                    children: [
                        {
                            type: "name",
                            title: "Bridge",
                            content: "Si su ISP no aparece y no requiere otros parámetros de configuración, puede simplemente seleccionar este modo y configurar las características del puerto LAN del router.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Asigne a su puerto LAN si quiere que suministre Internet o que suministre IPTV."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Rusia",
                            content: "Seleccione si su ISP es de Rusia y los parámetros necesarios son los predeterminados, incluyendo ID/Prioridad VLAN Internet/Teléfono IP/IPTV y características del puerto LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "ID/Prioridad VLAN Multicast IPTV",
                                    content: "Puede habilitar la característica de IPTV Multicast si lo desea y configurar la ID de VLAN y la Prioridad de acuerdo con su ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapur-ExStream",
                            content: "Seleccione si su ISP es ExStream de Singapur y los parámetros necesarios son predeterminados, incluyendo ID/Prioridad VLAN Internet/Teléfono IP/IPTV y características del puerto LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malasi-Unifi",
                            content: "Seleccione si su ISP es Unifi de Malasia y los parámetros necesarios son predeterminados, incluyendo ID/Prioridad VLAN Internet/Teléfono IP/IPTV y características del puerto LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malasia-Maxis",
                            content: "Seleccione si su ISP es Maxis de Malasia y los parámetros requeridos son predeterminados, incluyendo ID/Prioridad VLAN Internet/Teléfono IP/IPTV y características del puerto LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Personalizada",
                            content: "Seleccione si su ISP no aparece pero proporciona los parámetros requeridos, incluyendo ID/Prioridad VLAN Internet/Teléfono IP/IPTV y características del puerto LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "ID/Prioridad VLAN Internet/Teléfono IP/IPTV",
                                    content: "Configure los ID de VLAN proporcionados por su ISP."
                                }, {
                                    type: "name",
                                    title: "Etiqueta 802.11",
                                    content: "Seleccione si desea etiquetar los paquetes de Internet con 802.11Q."
                                }, {
                                    type: "name",
                                    title: "ID/Prioridad VLAN Multicast IPTV",
                                    content: "Puede habilitar la característica de IPTV multicast como desee y configurar la ID de VLAN y la Prioridad de acuerdo con su ISP."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Asigne si su puerto LAN funciona como proveedor de Internet o como proveedor de IPTV."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Proxy IGMP",
                    content: "Seleccione la versión Proxy IGMP (Internet Group Management Protocol), ya sea V2 o V3, de acuerdo con su ISP."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Ajustes",
            CONTENT: [
                {
                    type: "name",
                    title: "Servidor DHCP",
                    content: "De forma predeterminada, el servidor DHCP (Dynamic Host Configuration Protocol) está habilitado; Asigna dinámicamente los parámetros TCP/IP a los dispositivos cliente desde el rango de direcciones IP. NO deshabilite el servidor DHCP a menos que tenga otro servidor DHCP o desee asignar manualmente los parámetros TCP/IP a cada dispositivo cliente de su red."
                }, {
                    type: "name",
                    title: "Rango de Direcciones IP",
                    content: "Introduzca el rango de direcciones IP que pueden ser asignadas a los clientes."
                }, {
                    type: "name",
                    title: "Tiempo de Concesión de Dirección",
                    content: "Introduzca la duración de una dirección IP asignada al cliente entre 2 y 2880 minutos. El valor predeterminado es 120 minutos."
                }, {
                    type: "name",
                    title: "Puerta de Enlace Predeterminada",
                    content: "Introduzca la dirección IP de LAN. (Opcional)"
                }, {
                    type: "name",
                    title: "DNS Primario/DNS Secundario",
                    content: "Introduzca estos parámetros según lo proporcionado por su ISP. (Opcional)"
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Reserva de Direcciones",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Puede reservar manualmente una dirección IP para un cliente que esté conectado al router. Una vez reservada, la dirección IP sólo será asignada al mismo cliente por el servidor DHCP."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del cliente con dirección IP reservada en el DHCP."
                }, {
                    type: "name",
                    title: "Dirección IP Reservada",
                    content: "Muestra la dirección IP reservada del cliente."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra una descripción del dispositivo cliente."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) del dispositivo cliente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Eliminar el cliente correspondiente."
                }, {
                    type: "step",
                    title: "Reservar una Dirección IP",
                    content: [
                        "1. Pulse Añadir.",
                        "2. Introduzca la dirección MAC del cliente deseado.",
                        "3. Introduzca la dirección IP que quiera reservar para ese cliente.",
                        "4. Introduzca la descripción para el cliente.",
                        "5. Seleccione Habilitar.",
                        "6. Pulse OK."
                    ]
                }, {
                    type: "step",
                    title: "Modificar o borrar un cliente existente",
                    content: "En la tabla, haga clic en el icono Editar o en el icono Eliminar que corresponda al cliente que desea modificar o eliminar."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "Lista de Clientes DHCP",
            CONTENT: [
                {
                    type: "name",
                    title: "Número de Cliente",
                    content: "Muestra el número del cliente DHCP asociado."
                }, {
                    type: "name",
                    title: "Nombre de Cliente",
                    content: "Muestra el nombre del cliente DHCP."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC."
                }, {
                    type: "name",
                    title: "Dirección IP Asignada",
                    content: "Muestra la dirección IP asignada al cliente por el servidor DHCP."
                }, {
                    type: "name",
                    title: "Tiempo de Concesión",
                    content: "Muestra la duración de la dirección IP asignada al cliente."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Pulse para actualizar la lista de clientes DHCP."
                }
            ]
        },
        DDNS: {
            TITLE: "DNS Dinámico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "DNS dinámico le permite asignar un equipo y un nombre de dominio fijos a una dirección IP dinámica de Internet. Es útil cuando usted es su propio sitio web, servidor FTP u otro servidor detrás del router. En primer lugar, necesita registrarse con un proveedor de servicios DDNS como www.dyndns.com."
                }, {
                    type: "step",
                    title: "Configurar un DNS Dinámico",
                    content: ["1. Seleccione su proveedor de servicio DDNS.", "2. Introduzca el Usuario y Contraseña de su cuenta DDNS.", "3. Introduzca el Nombre de Dominio que recibe desde el proveedor de servicio DDNS.", "4. Seleccione el Intervalo de Actualización de la lista desplegable.", "5. Pulse Acceder y Guardar."]
                }, {
                    type: "paragraph",
                    content: "Para cambiar entre cuentas, primero debe desconectarse la cuenta actual y, a continuación, Acceder a la otra cuenta con el nuevo nombre de usuario y contraseña."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Enrutamiento Estático",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El enrutamiento estático se utiliza para predeterminar una ruta fija para que los paquetes de información de red alcancen un equipo o una red específica."
                }, {
                    type: "step",
                    title: "Configurar una Ruta Estática",
                    content: [
                        "1. Pulse Añadir.",
                        "2. Red de destino: introduzca una dirección IP en hexadecimal para asignar la ruta estática a esta entrada.",
                        "3. Máscara de subred: introduzca una máscara de subred en formato hexadecimal para determinar la porción de red y la porción de equipo de la dirección IP.",
                        "4. Puerta de enlace predeterminada: introduzca una dirección IP para la puerta predeterminada en formato hexadecimal para conectar el router a la red o al equipo.",
                        "5. Interfaz - Seleccione LAN o WAN para especificar el tipo de red de destino.",
                        "6. Descripción - Introduzca una breve descripción para esta entrada.",
                        "7. Seleccione Habilitar.",
                        "8. Pulse en Aceptar."
                    ]
                }, {
                    type: "step",
                    title: "Modifcar o borrar una entrada existente",
                    content: "En la tabla, haga clic en el icono Editar o en el icono Eliminar que corresponda a la entrada que desee modificar o eliminar."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Tabla de Rutas Estáticas",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Tabla de Rutas Estáticas muestra todas las entradas de ruta válidas que están actualmente en uso."
                }, {
                    type: "paragraph",
                    content: "Pulse en Actualizar para actualizar la Tabla de Rutas Estáticas."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Ajustes",
            CONTENT: [
                {
                    type: "name",
                    title: "Región",
                    content: "Seleccione su región en el menú desplegable. Si su país o región no aparece en la lista, puede estar restringido el uso de la radio inalámbrica en su ubicación."
                }, {
                    type: "paragraph",
                    content: "Pulse <b>Guardar<b> para guardar todos sus ajustes."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Las siguientes instrucciones son para redes inalámbricas <span class=\"anti_5g\"> 2,4GHz y 5GHz </span>."
                }, {
                    type: "name",
                    title: "Habilitar Radio Inlámbrica",
                    content: "Seleccione esta casilla para activar la frecuencia de radio inalámbrica."
                }, {
                    type: "name",
                    title: "Nombre de Red (SSID)",
                    content: "Puede dejar el nombre de red predeterminado (SSID) tal como está o crear un nuevo nombre (hasta 32 caracteres). Este campo distingue entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Active esta casilla si desea ocultar el nombre de red (SSID) correspondiente de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña inalámbrica entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales para proteger esta red inalámbrica."
                }, {
                    type: "name",
                    title: "Avanzado",
                    content: "Pulse para mostrar más ajustes avanzados."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccione una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccione esta opción para desactivar la seguridad inalámbrica. Es <b>altamente recomendado</b> habilitar la seguridad inalámbrica para proteger su red inalámbrica contra accesos no autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccione esta opción para habilitar el método de autenticación estándar basado en una clave precompartida (PSK), también denominada passphrase. Se recomienda esta opción. Si está seleccionado, configure lo siguiente.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versión",
                                    content: "Seleccione una versión de seguridad para su red inalámbrica.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opción admite la implementación múltiple del estándar WPA (Acceso Protegido Wi-Fi), como WPA y WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opción admite cifrado TKIP y AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opción proporciona un mejor nivel de seguridad que WPA-PSK y se recomienda."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptación",
                                    content: "Seleccione un tipo de cifrado de seguridad: <b>TKIP</b> (Protocolo de Integridad de Clave Temporal), <b>AES</b> (Estándar de Cifrado Avanzado) o <b>Auto</b> (para TKIP y AES). <b>NO</b> se recomienda utilizar el cifrado TKIP si el extensor de línea eléctrica funciona en modo 802.11n, ya que TKIP no es soportado por la especificación 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Seleccione esta opción para habilitar el método de autenticación básica si cualquiera de sus dispositivos cliente sólo puede acceder a la red inalámbrica utilizando WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Seleccione un tipo de autenticación para su red inalámbrica. El valor predeterminado es <b>Auto</b>, que selecciona automáticamente <b>Sistema Abierto</b> o <b>Clave Compartida</b> en función de la capacidad y la solicitud de acceso del cliente inalámbrico."
                                }, {
                                    type: "name",
                                    title: "Clave Seleccionada",
                                    content: "Seleccione una de las cuatro claves."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Utilice el formato <b>ASCII</b> o <b>Hexadecimal</b>. El formato ASCII es una combinación de caracteres alfabéticos y numéricos. El formato Hexadecimal es una combinación de números (0-9) y letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Clave",
                                    content: "Seleccione una longitud de clave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite introducir 10 dígitos hexadecimales (0-9, A-F, a-f) o 5 caracteres ASCII en el campo de contraseña."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite introducir 26 dígitos hexadecimales (0-9, A-F, a-f) o 13 caracteres ASCII en el campo de contraseña."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccione un modo mixto de transmisión."
                }, {
                    type: "name",
                    title: "Ancho de Canal",
                    content: "Seleccione un ancho de canal (ancho de banda) para la red inalámbrica correspondiente."
                }, {
                    type: "name",
                    title: "Canal ",
                    content: "Seleccione un canal operativo para la red inalámbrica correspondiente. Se recomienda dejar el canal en <b>Auto</b>, si no está experimentando problemas de conexión inalámbrica intermitentes."
                }, {
                    type: "name",
                    title: "Potencia de Transmisión",
                    content: "Seleccione <b>Alto</b>, <b>Medio</b> o <b>Bajo</b> para especificar la potencia de transmisión de los datos. El ajuste predeterminado y recomendado es <b>Alto</b>."
                }, {
                    type: "paragraph",
                    content: "Haga clic en <b>Guardar</b> para guardar todos los ajustes."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "Wi-Fi 2.4GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Radio Inlámbrica",
                    content: "Seleccione esta casilla para activar la frecuencia de radio inalámbrica de 2.4 GHz."
                }, {
                    type: "name",
                    title: "Nombre de Red (SSID)",
                    content: "Puede dejar el nombre de red predeterminado (SSID) tal cual o introducir un nuevo nombre (hasta 32 caracteres). Este campo distingue entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccione esta casilla si desea ocultar el nombre de red (SSID) de 2.4 GHz de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña inalámbrica entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales para proteger esta red inalámbrica."
                }, {
                    type: "name",
                    title: "Avanzado",
                    content: "Haga clic para mostrar más ajustes avanzados."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccione una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccione esta opción para desactivar la seguridad inalámbrica. Es <b>altamente recomendado</b> habilitar la seguridad inalámbrica para proteger su red inalámbrica de accesos no autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccione esta opción para habilitar el método de autenticación estándar basado en una clave precompartida (PSK), también denominada passphrase. Se recomienda esta opción. Si está seleccionado, configure lo siguiente.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versión",
                                    content: "Seleccione una versión de seguridad para su red inalámbrica.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opción admite la implementación múltiple del estándar WPA (Acceso Protegido Wi-Fi), como WPA y WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opción admite cifrado TKIP y AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opción proporciona un mejor nivel de seguridad que WPA-PSK y se recomienda."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptación",
                                    content: "Seleccione un tipo de cifrado de seguridad: <b>TKIP</b> (Protocolo de Integridad de Clave Temporal), <b>AES</b> (Estándar de Cifrado Avanzado) o <b>Auto</b> (para TKIP y AES ).  <b>NO</b> se recomienda utilizar el cifrado TKIP si el extensor de línea eléctrica funciona en modo 802.11n, ya que TKIP no es soportado por la especificación 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Seleccione esta opción para habilitar el método de autenticación básica si cualquiera de sus dispositivos cliente sólo puede acceder a la red inalámbrica utilizando WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Seleccione un tipo de autenticación para su red inalámbrica. El valor predeterminado es <b>Auto</b>, que selecciona automáticamente <b>Sistema Abierto</b> o <b>Clave Compartida</b> en función de la solicitud de capacidad y acceso del cliente inalámbrico."
                                }, {
                                    type: "name",
                                    title: "Clave Seleccionada",
                                    content: "Seleccione una de las cuatro claves."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Utilice el formato <b>ASCII</b> o <b>Hexadecimal</b>. El formato ASCII es una combinación de caracteres alfabéticos y numéricos. El formato hexadecimal es una combinación de números (0-9) y letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Clave",
                                    content: "Seleccione una longitud de clave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite introducir 10 dígitos hexadecimales (0-9, A-F, a-f) o 5 caracteres ASCII en el campo de contraseña."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite introducir 26 dígitos hexadecimales (0-9, A-F, a-f) o 13 caracteres ASCII en el campo de contraseña."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccione un modo mixto de transmisión."
                }, {
                    type: "name",
                    title: "Ancho de Canal",
                    content: "Seleccione un ancho de canal (ancho de banda) para la red inalámbrica de 2.4GHz."
                }, {
                    type: "name",
                    title: "Canal ",
                    content: "Seleccione un canal operativo para la red inalámbrica de 2.4GHz. Se recomienda dejar el canal en <b>Auto</b>, si no está experimentando problemas de conexión inalámbrica intermitentes."
                }, {
                    type: "name",
                    title: "Potencia de Transmisión",
                    content: "Seleccione <b>Alto</b>, <b>Medio</b> o <b>Bajo</b> para especificar la potencia de transmisión de datos. El ajuste predeterminado y recomendado es <b>Alto</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "Wi-Fi 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Radio Inlámbrica",
                    content: "Seleccione esta casilla para activar la frecuencia de radio inalámbrica de 5 GHz."
                }, {
                    type: "name",
                    title: "Nombre de Red (SSID)",
                    content: "Puede dejar el nombre de red predeterminado (SSID) tal cual o introducir un nuevo nombre (hasta 32 caracteres). Este campo distingue entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccione esta casilla si desea ocultar el nombre de red (SSID) de 5 GHz de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña inalámbrica entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales para proteger esta red inalámbrica."
                }, {
                    type: "name",
                    title: "Avanzado",
                    content: "Haga clic para mostrar más ajustes avanzados."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccione una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccione esta opción para desactivar la seguridad inalámbrica. Es <b>altamente recomendado</b> habilitar la seguridad inalámbrica para proteger su red inalámbrica de accesos no autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Seleccione esta opción para habilitar el método de autenticación estándar basado en una clave precompartida (PSK), también denominada passphrase. Se recomienda esta opción. Si está seleccionado, configure lo siguiente.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versión",
                                    content: "Seleccione una versión de seguridad para su red inalámbrica.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opción admite la implementación múltiple del estándar WPA (Acceso Protegido Wi-Fi), como WPA y WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opción admite cifrado TKIP y AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opción proporciona un mejor nivel de seguridad que WPA-PSK y se recomienda."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Encriptación",
                                    content: "Seleccione un tipo de cifrado de seguridad: <b>TKIP</b> (Protocolo de Integridad de Clave Temporal), <b>AES</b> (Estándar de Cifrado Avanzado) o <b>Auto</b> (para TKIP y AES ).  <b>NO</b> se recomienda utilizar el cifrado TKIP si el extensor de línea eléctrica funciona en modo 802.11n, ya que TKIP no es soportado por la especificación 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Seleccione esta opción para habilitar el método de autenticación básica si cualquiera de sus dispositivos cliente sólo puede acceder a la red inalámbrica utilizando WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Seleccione un tipo de autenticación para su red inalámbrica. El valor predeterminado es <b>Auto</b>, que selecciona automáticamente <b>Sistema Abierto</b> o <b>Clave Compartida</b> en función de la solicitud de capacidad y acceso del cliente inalámbrico."
                                }, {
                                    type: "name",
                                    title: "Clave Seleccionada",
                                    content: "Seleccione una de las cuatro claves."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Utilice el formato <b>ASCII</b> o <b>Hexadecimal</b>. El formato ASCII es una combinación de caracteres alfabéticos y numéricos. El formato hexadecimal es una combinación de números (0-9) y letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Clave",
                                    content: "Seleccione una longitud de clave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite introducir 10 dígitos hexadecimales (0-9, A-F, a-f) o 5 caracteres ASCII en el campo de contraseña."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite introducir 26 dígitos hexadecimales (0-9, A-F, a-f) o 13 caracteres ASCII en el campo de contraseña."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Seleccione un modo mixto de transmisión."
                }, {
                    type: "name",
                    title: "Ancho de Canal",
                    content: "Seleccione un ancho de canal (ancho de banda) para la red inalámbrica de 5GHz."
                }, {
                    type: "name",
                    title: "Canal ",
                    content: "Seleccione un canal operativo para la red inalámbrica de 5GHz. Se recomienda dejar el canal en <b>Auto</b>, si no está experimentando problemas de conexión inalámbrica intermitentes."
                }, {
                    type: "name",
                    title: "Potencia de Transmisión",
                    content: "Seleccione <b>Alto</b>, <b>Medio</b> o <b>Bajo</b> para especificar la potencia de transmisión de datos. El ajuste predeterminado y recomendado es <b>Alto</b>."
                }, {
                    type: "paragraph",
                    content: "Haga clic en <b> Guardar </b> para guardar todos los ajustes."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Programación Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La programación Wi-Fi le permiten establecer tiempos específicos para desactivar el Wi-Fi."
                }, {
                    type: "name",
                    title: "Programación Wi-Fi",
                    content: "Active <b>On</b> para habilitar la función de Programación Wi-Fi. Si desea que el Wi-Fi permanezca encendido mientras los dispositivos inalámbricos sigan conectados a la red inalámbrica, seleccione la casilla."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Clonado Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Clonado Wi-Fi se utiliza para copiar la configuración inalámbrica (incluyendo SSID y contraseña inalámbrica) desde el router inalámbrico principal hasta el extensor."
                }, {
                    type: "name",
                    title: "Selección de Banda Wi-Fi",
                    content: "Seleccione <span class=\"anti_5g\"> o ambos </span> para ser clonados. <Span class=\"anti_5g\"> Si el router principal sólo admite la clonación de una banda a la vez, le recomendamos que seleccione 2.4GHz y 5GHz aquí para asegurar que la banda clonada se corresponde con la banda permitida por su router. </span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Programación Apagado Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Desde",
                    content: "Muestra la hora cuando el Wifi se Apaga."
                }, {
                    type: "name",
                    title: "Hasta",
                    content: "Muestra la hora en que el Wi-Fi se Enciende de nuevo."
                }, {
                    type: "name",
                    title: "Día(s)",
                    content: "Muestra los días en los que el calendario es efectivo."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Indica si la programación está habilitada o no. Haga clic en el icono Bombilla para habilitar (o deshabilitar) la programación."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para <b>Modificar</b> o <b>Eliminar</b> la entrada correspondiente."
                }, {
                    type: "step",
                    title: "Añadir una nueva programación",
                    content: ["1. Pulse en <b>Añadir</b>.", "2. Especifique un intervalo de tiempo durante el cual el Wi-Fi se apagará.", "3. Seleccione el(los) día(s).", "4. Seleccione <b>Habilitar esta entrada</b>.", "5. Pulse en <b>Aceptar</b> para guardar esta entrada."]
                }, {
                    type: "paragraph",
                    content: "Para modificar o eliminar una entrada Wi-Fi desactivada, simplemente haga clic en el icono <b>Editar</b> para editar la información o en el icono <b>Papelera</b> para eliminar la entrada correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para eliminar varias programaciones, seleccione todas las programaciones y haga clic en <b>Eliminar</b> encima de la tabla."
                }
            ]
        },
        WPS: {
            TITLE: "PIN del Router",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Otros dispositivos pueden conectarse a este router mediante WPS con el PIN del router."
                }, {
                    type: "name",
                    title: "Habilitar PIN del Router",
                    content: "Active/Desactive para permitir que los dispositivos inalámbricos se conecten al router utilizando el PIN del router (número de identificación personal)."
                }, {
                    type: "name",
                    title: "PIN del Router",
                    content: "Muestra el PIN del router. El PIN predeterminado se encuentra en la etiqueta del router o en la Guía del usuario. Pulse en Generar para generar un nuevo PIN de forma aleatoria o pulse en Predeterminado para restaurar el PIN actual al PIN predeterminado de fábrica."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "Asistente WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccione un método de configuración"
                }, {
                    type: "name",
                    title: "Pulsar Botón (Recomendado)",
                    content: "Seleccione este método de configuración para permitir que la función WPS conecte fácilmente cualquier dispositivo habilitado para WPS a su red inalámbrica mediante el botón WPS o virtualmente con el botón Conectar."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Seleccione este método de configuración para agregar un dispositivo manualmente introduciendo el PIN WPS del dispositivo inalámbrico en el campo y pulse en Conectar."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "Clientes Inalámbricos en Línea",
            CONTENT: [
                {
                    type: "name",
                    title: "Clientes Totales",
                    content: "Muestra el número total de clientes inalámbricos conectados a la red powerline."
                }, {
                    type: "name",
                    title: "Nombre de Dispositivo",
                    content: "Muestra el nombre del cliente inalámbrico."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP que el cliente inalámbrico está utilizando."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del cliente inalámbrico."
                }, {
                    type: "name",
                    title: "Banda Inalámbrica",
                    content: "Muestra la banda de frecuencia <span class=\"anti_5g\"> (2.4GHz o 5GHz) </span> de la red inalámbrica a la que está conectado el cliente inalámbrico."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Muestra el tipo de seguridad del cliente inalámbrico."
                }, {
                    type: "paragraph",
                    content: "Haga clic en <b>Actualizar</b> para actualizar la información de esta página."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Red de Invitados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<B>Red de Invitados</b> le permite tener un nombre de red inalámbrica (SSID) y una contraseña que los invitados pueden usar para acceder a Internet."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Red de Invitados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<B>Red de Invitados</b> le permite tener un nombre de red inalámbrica (SSID) y una contraseña que los invitados pueden usar para acceder a Internet."
                }, {
                    type: "name",
                    title: "Permitir a los invitados verse entre sí",
                    content: "Seleccione esta casilla para permitir que los dispositivos inalámbricos de la red de invitados se comuniquen entre sí."
                }, {
                    type: "name",
                    title: "No permitir a los invitadpo gestionar mi red",
                    content: "Seleccione esta opción para evitar que los invitados se conecten a la interfaz de administración web."
                }, {
                    type: "name",
                    title: "Deshabilitar automáticamente después",
                    content: "Seleccione esta opción para desactivar automáticamente la red de invitados en función de un horario específico."
                }, {
                    type: "paragraph",
                    content: "Haga clic en <b>Guardar</b> para guardar todos los ajustes."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Ajustes de la Red de Invitados",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "Cambie entre 2,4 GHz y 5 GHz para mostrar sus configuraciones."
                }, {
                    type: "name",
                    title: "Habilitar Red de Invitados",
                    content: "Active esta casilla para habilitar la red de invitados."
                }, {
                    type: "name",
                    title: "Nombre de Red (SSID)",
                    content: "Utilice el SSID invitado predeterminado o cree un nuevo nombre (hasta 32 caracteres)."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccione una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccione esta opción para desactivar la seguridad inalámbrica. Es <u><b>altamente recomendable</b></u> que habilite la seguridad inalámbrica para proteger su Red de Invitados de accesos no autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Seleccione esta opción para habilitar el método de autenticación estándar basado en una clave precompartida (PSK), también denominada passphrase. Si está seleccionado, configure lo siguiente."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Utilice la contraseña predeterminada o cree una contraseña entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Haga clic en <b>Guardar</b> para guardar la configuración inalámbrica de la red de invitados."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Ajustes Inalámbricos",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Red de Invitados",
                    content: "Active esta casilla para habilitar la red de invitados."
                }, {
                    type: "name",
                    title: "Nombre de Red (SSID)",
                    content: "Utilice el SSID invitado predeterminado o cree un nuevo nombre (hasta 32 caracteres)."
                }, {
                    type: "name",
                    title: "Seguridad",
                    content: "Seleccione una de las siguientes opciones de seguridad:",
                    children: [
                        {
                            type: "name",
                            title: "Sin Seguridad",
                            content: "Seleccione esta opción para desactivar la seguridad inalámbrica. Es <u><b>altamente recomendable</b></u> que habilite la seguridad inalámbrica para proteger su Red de Invitados de accesos no autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Seleccione esta opción para habilitar el método de autenticación estándar basado en una clave precompartida (PSK), también denominada passphrase. Si está seleccionado, configure lo siguiente."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Utilice la contraseña predeterminada o cree una contraseña entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Haga clic en <b>Guardar</b> para guardar la configuración inalámbrica de la red de invitados."
                }
            ]
        },
        NAT: {
            TITLE: "Puerta de Enlace de Capa de Aplicación (ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG permite que los filtros transversales de Traducción de Direcciones de Red (NAT) personalizados se conecten a la puerta de enlace para soportar la traducción de direcciones y puertos para ciertos protocolos de \"control/datos\" de la capa de aplicación: FTP, TFTP, H323 etc. Se recomienda habilitar ALG."
                }, {
                    type: "name",
                    title: "Habilitar FTP ALG",
                    content: "Si se selecciona, permite a los clientes y servidores FTP (Protocolo de Transferencia de Archivos) transferir datos a través de NAT."
                }, {
                    type: "name",
                    title: "Habilitar TFTP ALG",
                    content: "Si se selecciona, permite a los clientes y servidores TFTP (Protocolo de Transferencia de Archivos Transversal) transferir datos a través de NAT."
                }, {
                    type: "name",
                    title: "Habilitar H323 ALG",
                    content: "Si se selecciona, permite a los clientes de Microsoft NetMeeting comunicarse a través de NAT."
                }, {
                    type: "name",
                    title: "Habilitar RTSP ALG",
                    content: "Si se selecciona, permite a los clientes de reproductores de medios comunicarse con servidores de medios streaming a través de NAT."
                }, {
                    type: "name",
                    title: "Habilitar PPTP Passthrough",
                    content: "Si se selecciona, permite que las sesiones punto a punto se comuniquen mediante un túnel a través de una red IP y se pasen a través del router."
                }, {
                    type: "name",
                    title: "Habilitar L2TP Passthrough",
                    content: "Si se selecciona, permite que las sesiones Punto-a-Punto de Capa 2 se comuniquen mediante un túnel a través de una red IP y se pasen a través del router."
                }, {
                    type: "name",
                    title: "Habilitar IPSec Passthrough",
                    content: "Si se selecciona, permite que la seguridad del protocolo de Internet (IPSec) se comuniquen mediante un túnel a través de una red IP y se pasen a través del router. IPSec utiliza servicios de seguridad critográficos para asegurar comunicaciones privadas y seguras a través de redes IP."
                }, {
                    type: "paragraph",
                    content: "Pulse en Guardar para guardar todos los ajustes."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Servidores Virtuales",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Los Servidores Virtuales se utilizan para configurar servicios públicos en su red local. Un servidor virtual se define como un puerto externo al que todas las solicitudes de Internet a este puerto se redirigirán a un equipo designado, que debe configurarse con una dirección IP estática o reservada."
                }, {
                    type: "name",
                    title: "Tipo de Servicio",
                    content: "Muestra el nombre de su servidor virtual."
                }, {
                    type: "name",
                    title: "Puerto Externo",
                    content: "Muestra el número de puerto o un rango de puertos utilizados por el servidor virtual."
                }, {
                    type: "name",
                    title: "IP Interna",
                    content: "Muestra la dirección IP del equipo que ejecuta la aplicación de servicio."
                }, {
                    type: "name",
                    title: "Puerto Interno",
                    content: "Muestra el número de puerto del ordenador que ejecuta la aplicación de servicio."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Muestra el protocolo utilizado para la aplicación de servicio: TCP, UDP o Todos (Todos los protocolos admitidos por el router)."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) de la regla de filtrado específica."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Eliminar la regla correspondiente."
                }, {
                    type: "step",
                    title: "Para configurar una regla de Servidor Virtual",
                    content: ["1. Pulse en Agregar.", "2. Pulse en Ver Servicios Existentes para seleccionar un servicio de la lista y completar automáticamente el número de puerto apropiado en los campos Puerto externo y Puerto interno. Si el servicio no aparece en la lista, introduzca el número de puerto externo (por ejemplo, 21) o un rango de puertos (por ejemplo, 21-25). Deje el puerto interno en blanco si es el mismo que el puerto externo o introduzca un número de puerto específico (por ejemplo, 21) si el puerto externo es un puerto único. Introduzca la dirección IP del equipo que ejecuta la aplicación de servicio en formato decimal con puntos en el campo IP interna.", "3. Seleccione un protocolo para la aplicación de servicio: TCP, UDP o Todo en la lista desplegable del Protocolo.", "4. Seleccione Habilitar.", "5. Pulse en Aceptar"]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una regla de Apertura de Puertos",
                    content: "Pulse en el icono Modificar o en el icono Papelera que corresponda a la regla que desea modificar o eliminar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples reglas",
                    content: "Seleccione todas las entradas que desea eliminar, pulse en Eliminar encima de la tabla."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si su dispositivo equipo local aloja más de un tipo de servicios disponibles, debe crear una regla para cada servicio."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Port Triggering",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Port Triggering se utiliza para reenviar tráfico en un determinado puerto a un servidor específico de la red."
                }, {
                    type: "name",
                    title: "Aplicación",
                    content: "Muestra el nombre de la aplicación."
                }, {
                    type: "name",
                    title: "Puerto Triggering",
                    content: "Muestra el puerto de tráfico saliente utilizado para activar una regla de filtrado de una conexión saliente."
                }, {
                    type: "name",
                    title: "Protocolo Triggering",
                    content: "Muestra el protocolo utilizado para activar el puerto. TCP, UDP o Todos (Todos los protocolos soportados por el router)."
                }, {
                    type: "name",
                    title: "Puerto Externo",
                    content: "Muestra el puerto o rango de puertos utilizado por el sistema remoto. Una respuesta utilizando uno de estos puertos se reenviará al PC que activa esta regla. Puede introducir al menos 5 grupos de puertos (o secciones de puerto). Cada grupo de puertos debe estar separado por \",\" (comas), por ejemplo, 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "Protocolo Externo",
                    content: "Muestra el protocolo utilizado para el Puerto Entrante: TCP, UDP o ALL (Todos los protocolos admitidos por el router)."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (habilitado o deshabilitado) de la regla de filtrado específica."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones de Modificar o Eliminar y la regla correspondiente."
                }, {
                    type: "step",
                    title: "Para configurar una regla de Port Triggering",
                    content: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "Cada regla sólo puede ser utilizada por un equipo a la vez."
                        },
                        "1. Pulse en Agregar.", {
                            content: "2. Pulse en Ver Aplicaciones Existentes para seleccionar una aplicación de la lista y rellenar automáticamente los valores predeterminados en los campos apropiados. Si desea agregar una aplicación no listada, introduzca manualmente la aplicación, el puerto y protocolo de activación, el puerto y el protocolo externo.",
                            children: [
                                {
                                    type: "note",
                                    title: "Nota",
                                    content: "Las reglas no pueden tener intervalos de puertos que se superponen entre sí (por ejemplo, la regla 1 tiene el rango de puertos 4200-4205, lo que significa que la regla 2 no puede tener rango de puertos de 4203-4206)."
                                }
                            ]
                        },
                        "3. Seleccione Habilitar.",
                        "4. Pulse en Aceptar."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una regla de Port Triggering",
                    content: "En la tabla, haga clic en el icono Modificar o en el icono Papelera que corresponda a la regla que desea modificar o eliminar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples reglas de Port Triggering",
                    content: "En la tabla, seleccione todas las reglas que desea eliminar, pulse en Eliminar encima de la tabla."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La función de equipo DMZ (Zona Desmilitarizada) permite que un equipo local se exponga a Internet para un servicio de propósito especial, como juegos de Internet o videoconferencia. Básicamente, el DMZ permite que un solo ordenador de su LAN abra todos sus puertos. Este equipo debe configurarse con una dirección IP estática y tener su función de cliente DHCP deshabilitada."
                }, {
                    type: "step",
                    title: "Hacer que un ordenador o servidor sea un servidor DMZ",
                    content: ["1. Pulse en Activar DMZ.", "2. En el campo Dirección IP del equipo DMZ, introduzca la dirección IP de un ordenador local para configurar el equipo DMZ.", "3. Pulse en Guardar."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Por defecto, la función UPnP (Universal Plug-and-Play) está habilitada para permitir que dispositivos, como ordenadores y dispositivos de Internet, se encuentren y se comuniquen automáticamente entre sí en la red local."
                }, {
                    type: "paragraph",
                    content: "La lista de servicios UPnP muestra la información del dispositivo UPnP."
                }, {
                    type: "name",
                    title: "Descripción del Servicio",
                    content: "Muestra una breve descripción del puerto local que inicia la solicitud UPnP."
                }, {
                    type: "name",
                    title: "Puerto Externo",
                    content: "Muestra el puerto externo que abre el puerto local."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Muestra el tipo de protocolo de red que utiliza el equipo local."
                }, {
                    type: "name",
                    title: "Dirección IP Interna",
                    content: "Muestra la dirección IP del equipo local."
                }, {
                    type: "name",
                    title: "Puerto Interno",
                    content: "Muestra el puerto interno que abre el equipo local."
                }, {
                    type: "paragraph",
                    content: "Pulse en Actualizar para actualizar la lista de servidores UPnP."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Ajustes del Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página Configuración del dispositivo muestra la información relacionada de cualquier dispositivo de almacenamiento USB conectado a través del puerto USB."
                }, {
                    type: "name",
                    title: "Escanear",
                    content: "Por lo general, el router detecta automáticamente cualquier dispositivo recién conectado. Si no, pulse en este botón para buscar cualquier nuevo dispositivo conectado y actualice la página con la información actualizada."
                }, {
                    type: "name",
                    title: "Volumen",
                    content: "Muestra el nombre del volumen USB."
                }, {
                    type: "name",
                    title: "Capacidad",
                    content: "Muestra la capacidad total de almacenamiento del USB."
                }, {
                    type: "name",
                    title: "Espacio Libre",
                    content: "Muestra el espacio de almacenamiento libre disponible actual."
                }, {
                    type: "name",
                    title: "Quitar de Manera Segura",
                    content: "Pulse en este botón para desconectar con seguridad el dispositivo de almacenamiento USB antes de desconectarlo físicamente del router."
                }, {
                    type: "paragraph",
                    content: "Tenga en cuenta que el botón Quitar de forma segura sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router y no podrá desconectar el dispositivo USB mientras el volumen actual esté ocupado."
                }, {
                    type: "name",
                    title: "Activar",
                    content: "Esta casilla de verificación sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router. Seleccione esta opción para habilitar el uso compartido de archivos del dispositivo USB."
                }, {
                    type: "step",
                    title: "Configurar un servidor de archivos",
                    content: ["1. Conecte el dispositivo de almacenamiento USB al puerto USB del router mediante un cable USB.", "2. El dispositivo USB recién conectado debe ser detectado automáticamente por el router y mostrar la información en la sección Configuración del dispositivo. Si no, pulse en Escanear.", "3. Seleccione Activo para habilitar el uso compartido de archivos."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Cuenta de Uso Compartido",
            CONTENT: [
                {
                    type: "name",
                    title: "Cuenta",
                    content: "Puede seleccionar Usar Cuenta Predeterminada para iniciar sesión en los archivos y carpetas compartidos o Usar Nueva Cuenta e introducir lo siguiente para crear una nueva cuenta de usuario."
                }, {
                    type: "name",
                    title: "Usuario/Contraseña",
                    content: "Introduzca una cadena alfanumérica o un guión bajo de hasta 15 caracteres de longitud. El nombre de usuario debe comenzar con un carácter del alfabeto. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Confirmar Contraseña",
                    content: "Vuelva a introducir la contraseña para confirmar que no hay errores tipográficos. Este campo también distingue entre mayúsculas y minúsculas."
                }, {
                    type: "paragraph",
                    content: "Pulse en Guardar para guardar la nueva cuenta de usuario."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Ajustes de Uso Compartido",
            CONTENT: [
                {
                    type: "name",
                    title: "Red/Nombre del Servidor Multimedia",
                    content: "Muestra el nombre utilizado para acceder al dispositivo de almacenamiento USB conectado."
                }, {
                    type: "name",
                    title: "Habilitar",
                    content: "Seleccione para habilitar el método de acceso."
                }, {
                    type: "name",
                    title: "Método de Acceso",
                    content: "Hay tres métodos de acceso para permitir el acceso al dispositivo de almacenamiento USB conectado. Puede elegir uno o más métodos de acceso seleccionando la casilla correspondiente.",
                    children: [
                        {
                            type: "name",
                            title: "Vecino de Red",
                            content: "Si está habilitado, los usuarios de su red pueden acceder al dispositivo de almacenamiento USB utilizando una dirección IP asignada (por ejemplo, \\\\192.168.0.1). Este método está habilitado de forma predeterminada."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Si está activado, los clientes FTP de su red local pueden acceder al dispositivo de almacenamiento USB utilizando la dirección IP asignada, seguido del número de puerto del servidor FTP (por ejemplo, ftp://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (Vía Internet)",
                            content: "Si está habilitado, los usuarios pueden acceder remotamente a la unidad de almacenamiento USB a través de FTP a través de Internet. Esta función admite la  carga y descarga de archivos. Para cambiar el número de puerto del servidor FTP, ingrese un número de puerto y pulse en Guardar para aplicar los cambios."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Enlace",
                    content: "Muestra la dirección utilizada para acceder al dispositivo de almacenamiento USB compartido."
                }, {
                    type: "name",
                    title: "Puerto",
                    content: "Muestra el número de puerto del servidor FTP."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Carpeta Comaprtida",
            CONTENT: [
                {
                    type: "name",
                    title: "Compartir Todo",
                    content: "Active para compartir todos los archivos y carpetas o desactive para compartir únicamente las carpetas seleccionadas."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Se recomienda habilitar la autenticación para requerir que los usuarios introduzcan un nombre de usuario y una contraseña válidos para acceder a las carpetas de uso compartido."
                }, {
                    type: "name",
                    title: "Nombre de Carpeta",
                    content: "Muestra el nombre de la carpeta compartida."
                }, {
                    type: "name",
                    title: "Ruta de Carpeta",
                    content: "Muestra la ruta de la carpeta compartida."
                }, {
                    type: "name",
                    title: "Archivos Multimedia Compartidos",
                    content: "Indica si la carpeta compartida está permitida para compartir multimedia o no."
                }, {
                    type: "name",
                    title: "Nombre de Volumen",
                    content: "Muestra el nombre del volumen compartido."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado de la carpeta compartida mediante el indicador de bombilla. Verde (ON) si está activado y Gris (OFF) si está desactivado. Puede habilitar o deshabilitar el uso compartido haciendo clic en la bombilla."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar y Eliminar la carpeta compartida correspondiente."
                }, {
                    type: "name",
                    title: "Buscar",
                    content: "Pulse para buscar una carpeta compartida."
                }, {
                    type: "name",
                    title: "Permitir el Acceso  la Red de Invitados",
                    content: "Seleccione esta opción para permitir que los clientes de la Red de Invitados accedan a las carpetas compartidas."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Seleccione para que los usuarios tengan acceso a las carpetas compartidas con un nombre de usuario y una contraseña válidos."
                }, {
                    type: "name",
                    title: "Habilitar Acceso Escritura",
                    content: "Seleccione esta opción para permitir a los usuarios realizar cambios en el contenido de la carpeta."
                }, {
                    type: "name",
                    title: "Habilitar Compartir Archivos Multimedia",
                    content: "Seleccione esta opción para habilitar el uso compartido de medios."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Servidor de Impresión",
            CONTENT: [
                {
                    type: "step",
                    title: "Configurar un Servidor de Impresión para ser usado en su red",
                    content: ["1. Conecte una impresora USB al puerto USB del router a través de un cable USB.", "2. Instale el controlador de impresora en su ordenador. Consulte los manuales del fabricante del ordenador para obtener instrucciones.", "3. Instale la Utilidad del controlador de impresora USB de TP-LINK, desde el CD de recursos (sólo para Windows) o descargue (para Windows y Mac OS X) desde el sitio web oficial de TP-LINK."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Controles Parentales",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Con el control parental, puede establecer límites de tiempo para dispositivos inalámbricos y controlar cuándo estos dispositivos pueden acceder a Internet."
                }, {
                    type: "name",
                    title: "Controles Parentales",
                    content: "Seleccione <b>On</b> para activar la función de control parental."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Dispositivos bajo Control Parental",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Muestra el ID del dispositivo cliente."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del dispositivo cliente."
                }, {
                    type: "name",
                    title: "Tiempo de Acceso a Internet",
                    content: "Muestra los períodos de acceso permitidos."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra una breve descripción del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Indica si el control parental está activado o no para el dispositivo correspondiente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones de <b>Modificar</b> o <b>Eliminar</b> del dispositivo."
                }, {
                    type: "step",
                    title: "Para configurar un límite de tiempo para un nuevo dispositivo cliente",
                    content: [
                        "1. Pulse en <b>Añadir</b>.",
                        "2. Pulse en <b>Ver Dispositivos Existentes</b> y elija un dispositivo conectado actualmente en la lista <b>Dispositivo de Acceso Inalámbrico</b>. O ingrese manualmente la <b>Dirección MAC</b> para agregar un dispositivo que no esté conectado.",
                        "3. Pulse en el icono <b>Hora de Acceso a Internet</b> para especificar los intervalos de tiempo durante los que se permite que el dispositivo tenga acceso a Internet.",
                        "4. Introduzca una breve descripción en el campo <b>Descripción</b>. Este campo es opcional.",
                        "5. Seleccione <b>Habilitar esta Entrada</b>.",
                        "6. Pulse en <b>Aceptar</b> para guardar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar o eliminar un dispositivo de la lista, simplemente haga clic en el icono <b>Editar</b> para editar la información o en el icono <b>Papelera</b> para eliminar la entrada correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para eliminar varios dispositivos de la lista, seleccione la casilla de verificación correspondiente de los dispositivos que desea eliminar y haga clic en <b>Eliminar</b> encima de la tabla."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Restricción de Contenido",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Negra",
                    content: "Contiene palabras clave que se utilizarán para bloquear cualquier acceso al sitio web de los dispositivos cliente especificados en la Lista de Control Parental.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Pulse en Agregar una nueva palabra clave para agregar una palabra clave a la lista negra. Para eliminar una palabra clave, haga clic en el icono (-) de la palabra clave que desea eliminar."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Lista Blanca",
                    content: "Contiene las direcciones de sitios web a los que los dispositivos cliente especificados en la lista de control parental pueden acceder.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Pulse en Agregar un nuevo nombre de dominio para agregar un sitio web a la lista blanca. Para eliminar un sitio web, haga clic en el icono (-) del sitio web que desea eliminar."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Las palabras clave también pueden ser nombres de dominio, por ejemplo, www.mail.google.com o www.facebook.com."
                }, {
                    type: "paragraph",
                    content: "Pulse en Guardar para guardar la configuración."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Calidad de Servicio (QoS) ayuda a priorizar el tráfico de Internet basado en sus necesidades. Puede especificar el nivel de prioridad para un dispositivo o una aplicación en la lista de reglas QoS."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si NAT Boost está habilitado, QoS debe estar deshabilitado."
                }, {
                    type: "name",
                    title: "Habilitar QoS",
                    content: "Pulse en este cuadro para habilitar la función QoS."
                }, {
                    type: "name",
                    title: "Ancho de Banda de Subida",
                    content: "Introduzca el ancho de banda máximo de subida proporcionado por su ISP (Proveedor de Servicio de Internet)."
                }, {
                    type: "name",
                    title: "Ancho de Banda de Bajada",
                    content: "Introduzca el ancho de banda máximo de descarga proporcionado por su ISP."
                }, {
                    type: "name",
                    title: "Garantizar Prioridad Alta",
                    content: "Especifique un porcentaje para el tráfico de prioridad alta."
                }, {
                    type: "name",
                    title: "Garantizar Prioridad Media",
                    content: "Especifique un porcentaje para el tráfico de prioridad media."
                }, {
                    type: "name",
                    title: "Garantizar Prioridad Baja",
                    content: "Especifique un porcentaje para el tráfico de prioridad baja."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "La cantidad (porcentaje) de todas las prioridades debería ser 1."
                }, {
                    type: "paragraph",
                    content: "Haga clic en Guardar para guardar todos los ajustes."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "Lista de Reglas QoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo",
                    content: "Seleccione un tipo para agregar la lista de reglas de QoS."
                }, {
                    type: "step",
                    title: "Para configurar una regla para prioridad alta/media/baja Por Dispositivo",
                    content: ["1. Pulse en Agregar.", "2. Seleccione Por dispositivo.", "3. Haga clic en Ver dispositivos existentes para seleccionar el dispositivo deseado en la Lista de dispositivos de acceso o puede introducir un nombre de dispositivo y su dirección MAC manualmente en los campos Nombre de dispositivo y Dirección MAC.", "4. Pulse en Aceptar."]
                }, {
                    type: "step",
                    title: "Para configurar una regla para prioridad alta/media/baja Por Aplicación",
                    content: ["1. Pulse en Agregar.", "2. Seleccione Por Aplicación.", "3. Seleccione la aplicación deseada en la lista de aplicaciones o puede personalizar una aplicación configurando el nombre, el protocolo y el puerto en los campos correspondientes.", "4. Pulse en Aceptar."]
                }, {
                    type: "step",
                    title: "Para configurar una regla para prioridad alta/media/baja Por Puerto Físico ",
                    content: ["1. Pulse en Agregar.", "2. Seleccione Por Puerto Físico.", "3. Seleccione el puerto deseado.", "4. Pulse en Aceptar."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Actualización de la Base de Datos",
            CONTENT: [
                {
                    type: "name",
                    title: "Nuevo Archivo de Base de Datos",
                    content: "Pulse en Examinar para localizar el nuevo archivo de base de datos. Seleccione y pulse en Actualizar para actualizar su base de datos a una versión más reciente."
                }, {
                    type: "name",
                    title: "Versión de la Base de Datos",
                    content: "Muestra la versión actual de la base de datos."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Firewall",
            CONTENT: [
                {
                    type: "name",
                    title: "Firewall SPI",
                    content: "El cortafuegos SPI (Stateful Packet Inspection) evita ataques cibernéticos y valida el tráfico que pasa por el router basado en el protocolo. El SPI Firewall está habilitado de forma predeterminada."
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "Protección DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Protección DoS",
                    content: "La protección contra Denegación de Servicio (DoS) protege su LAN contra los ataques DoS de inundar su red con las solicitudes del servidor. De manera predeterminada, la protección DoS está desactivada (Off)."
                }, {
                    type: "name",
                    title: "Filtrado contra Ataques FLUJO-ICMP",
                    content: "Habilitar para evitar el ataque de inundación ICMP (Internet Control Message Protocol)."
                }, {
                    type: "name",
                    title: "Filtrado contra Ataques FLUJO-UDP",
                    content: "Habilitar para evitar el ataque de inundación de UDP (User Datagram Protocol)."
                }, {
                    type: "name",
                    title: "Filtrado contra Ataques FLUJO-TCP-SYN",
                    content: "Habilitar para evitar el ataque de inundación de TCP-SYN (Transmission Control Protocol-Synchronize).",
                    children: [
                        {
                            type: "name",
                            title: "Apagado",
                            content: "Sin protección."
                        }, {
                            type: "name",
                            title: "Bajo",
                            content: "Nivel bajo de protección y bajo impacto en el rendimiento del router."
                        }, {
                            type: "name",
                            title: "Medio",
                            content: "Nivel moderado de protección e impacto semipermanente en el rendimiento del router."
                        }, {
                            type: "name",
                            title: "Alto",
                            content: "Nivel alto de protección e impacto notable en el rendimiento del router."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignorar Paquetes Ping desde Puerto WAN",
                    content: "Habilite para ignorar los paquetes de ping desde el puerto WAN."
                }, {
                    type: "name",
                    title: "Prohibir Paquetes Ping desde Puerto LAN",
                    content: "Habilite para prohibir los paquetes de ping desde el puerto LAN."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "Filtrado MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El filtrado MAC se utiliza para permitir o bloquear que equipos específicos y otros dispositivos accedan a su red. Cuando un dispositivo está bloqueado, no puede conectarse al dispositivo de línea eléctrica."
                }, {
                    type: "name",
                    title: "Ajustes de Filtrado MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtrado MAC",
                            content: "Active <b>On</b> para activar esta función. Si la función está desactivada (Off), todos los dispositivos pueden conectarse."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Seleccionar la regla de filtrado",
                    content: "Seleccione para bloquear o permitir que los dispositivos de cliente que aparecen en la lista de dispositivos tengan acceso a la red inalámbrica. Pulse en <b>Guardar</b> para guardar la configuración."
                }, {
                    type: "name",
                    title: "Lista de Dispositivos",
                    children: [
                        {
                            type: "step",
                            title: "Para añadir un dispositivo cliente"
                        }, {
                            type: "step",
                            title: "Para modificar o borrar un dispositivo cliente ",
                            content: "Pulse en el icono <b>Editar</b> o en el icono <b>Papelera</b> que corresponda al dispositivo que desea modificar o eliminar."
                        }, {
                            type: "step",
                            title: "Para borrar múltiples dispositivos en la Lista de Dispositivos",
                            content: "Seleccione la casilla correspondiente de los dispositivos que desea eliminar y haga clic en <b>Eliminar</b> encima de la tabla."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "Filtrado MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El filtrado MAC se utiliza para permitir o bloquear que equipos específicos y otros dispositivos accedan a su red. Cuando un dispositivo está bloqueado, no puede conectarse al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Ajustes Filtrado MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtrado MAC",
                            content: "Active <b>On</b> para activar esta función. Si la función está desactivada (Off), todos los dispositivos pueden conectarse."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Seleccionar la regla de filtrado",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccione para bloquear o permitir que los dispositivos del cliente que aparecen en la lista de dispositivos tengan acceso a la red inalámbrica."
                }, {
                    type: "paragraph",
                    content: "Pulse en <b>Guardar</b> para guardar la configuración."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Lista de Dispositivos",
            CONTENT: [
                {
                    type: "step",
                    title: "Para añadir un dispositivo cliente",
                    content: ["1. Pulse en <b>Añadir</b>.", "2. Pulse en <b>Ver dispositivos</b> y seleccione la dirección MAC del dispositivo de la lista o introduzca la dirección MAC manualmente.", "3. Describa brevemente el dispositivo.", "4. Seleccione <b>Habilitar esta entrada.</b>", "5. Pulse en <b>Aceptar</b>."]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un dispositivo de la Lista de Dispositivos",
                    content: "Haga clic en el icono <b>Editar</b> o en el icono <b>Papelera</b> que corresponda al dispositivo que desea modificar o eliminar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples dispositivos de la Lista de Dispositivos",
                    content: "Seleccione la casilla de verificación correspondiente de los dispositivos que desea eliminar y haga clic en <b>Eliminar</b> encima de la tabla."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Con la función Wi-Fi Move habilitada, cualquier cambio realizado en la configuración Wi-Fi de un extensor powerline se sincronizará automáticamente con otros extensores powerline en la misma red  eléctrica cuya función Wi-Fi Move también está habilitada. Tenga en cuenta que si se utiliza el nombre predeterminado de fábrica, es decir, HomePlugAV, la función Wi-Fi Move se deshabilitará automáticamente."
                }, {
                    type: "name",
                    title: "Wi-Fi Move",
                    content: "Active <b>On</b> para activar esta función."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Lista de Clientes DoS Bloqueados",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista de Equipos DoS Bloqueados",
                    content: "Lista las direcciónes IP y MAC de cualquier fuente de ataque DoS bloqueada."
                }, {
                    type: "step",
                    title: "Para borrar una entrada",
                    content: "En la lista de equipos, seleccione la entrada que desea eliminar y pulse en Eliminar en la parte superior de la tabla."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Control de Acceso",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El Control de Acceso se utiliza para permitir o bloquear equipos específicos y otros dispositivos de acceso a su red. Cuando un dispositivo está bloqueado, es capaz de obtener una dirección IP del router, pero no puede comunicarse con otros dispositivos o conectarse a Internet."
                }, {
                    type: "paragraph",
                    content: "Para utilizar el Control de Acceso, active esta función y especifique una lista negra o lista blanca. Si el control de acceso está desactivado (Off), todos los dispositivos, incluidos en la lista negra, pueden conectarse."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Modo de Acceso",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Negra",
                    content: "Sólo los dispositivos de la lista negra no podrán acceder a la red."
                }, {
                    type: "name",
                    title: "Lista Blanca",
                    content: "Sólo los dispositivos de la lista blanca acceder a la red."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Dispositivos Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre de Dispositivo",
                    content: "Muestra el nombre del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "Muestra el tipo de conexión del dispositivo conectado."
                }, {
                    type: "step",
                    title: "Para bloquear un dispositivo",
                    content: "En la tabla Dispositivos En Línea, pulse en el icono Bloquear en la columna Modificar que corresponde al dispositivo que desea bloquear."
                }, {
                    type: "step",
                    title: "Para bloquear múltiples dispositivos",
                    content: "En la tabla Dispositivos En Línea, seleccione todos los dispositivos que desea bloquear, pulse en Bloquear sobre la tabla. El dispositivo se agregará automáticamente a los dispositivos de lista negra o lista blanca."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Dispositivos en la lista Blanca/Negra",
            CONTENT: [
                {
                    type: "step",
                    title: "Para añadir un dispositivo a la lista negra o a la lista blanca",
                    content: ["1. Pulse en el icono Agregar.", "2. Introduzca el nombre del dispositivo.", "3. Introduzca la dirección MAC del dispositivo.", "4. Pulse en Aceptar."]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un dispositivo de la Lista Negra/Lista Blanca",
                    content: "En la tabla de la lista Blanca/lista Negra, pulse en el icono Modificar o en el icono Eliminar que corresponde al dispositivo que desea modificar o eliminar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples dispositivos de la Lista Negra/Lista Blanca",
                    content: "En la tabla de la lista Blanca/lista Negra, seleccione todos los dispositivos que desea eliminar, haga clic en Eliminar en la lista."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Ajustes",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El enlace ARP (Address Resolution Protocol) es útil para controlar el acceso de un ordenador específico en la LAN vinculando la dirección IP y la dirección MAC del dispositivo. El enlace ARP también evita que otros dispositivos utilicen una dirección IP específica."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "Lista ARP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra las direcciones MAC e IP de los dispositivos conectados actualmente."
                }, {
                    type: "name",
                    title: "Número de Entrada ARP",
                    content: "Muestra el número total de dispositivos que están actualmente conectados al router."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del dispositivo conectado."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP asignada al dispositivo conectado."
                }, {
                    type: "name",
                    title: "Vinculado",
                    content: "Indica si las direcciones MAC e IP están vinculadas o no."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para vincular o eliminar la entrada correspondiente de la lista."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "No puede vincular la misma dirección IP a más de una dirección MAC."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Lista de Binding",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar un dispositivo con ARP binding",
                    content: [
                        "1. Pulse en Agregar.",
                        "2. Introduzca la dirección MAC del dispositivo.",
                        "3. Introduzca una dirección IP que desee enlazar a la dirección MAC anterior.",
                        "4. Introduzca una descripción para este dispositivo. (Opcional)",
                        "5. Seleccione Habilitar.",
                        "6. Pulse en Aceptar."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar o borrar una entrada",
                    content: "En la Lista Binding, pulse en el icono Modificar o en el icono Eliminar que corresponda a la entrada que desea modificar o eliminar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples entradas",
                    content: "En la Lista Binding, seleccione todas las entradas que desee eliminar, pulse en Eliminar en la lista."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Seleccione para activar (On) o desactivar (Off) la función IPv6 del router."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Estática"
                }, {
                    type: "name",
                    title: "IP Estática",
                    content: "Seleccione este tipo si su ISP utiliza la asignación de dirección IPv6 estática."
                }, {
                    type: "name",
                    title: "Dirección IPv6/Máscara de Subred/Puerta de Enlace Predeterminada/DNS Primario/DNS Secundario",
                    content: "Introduzca los parámetros proporcionados por el ISP."
                }, {
                    type: "name",
                    title: "Tamañano MTU",
                    content: "El tamaño predeterminado y típico de MTU (Maximum Transmission Unit) para la mayoría de las redes Ethernet es de 1500 bytes. No se recomienda cambiar el tamaño predeterminado de MTU a menos que sea requerido por su ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión de Internet: IP Dinámica"
                }, {
                    type: "name",
                    title: "IP Dinámica",
                    content: "Seleccione esto si su ISP utiliza asignación de dirección IPv6 dinámica."
                }, {
                    type: "name",
                    title: "Dirección IP/Máscara de Subred/Puerta de Enlace Predeterminada/DNS Primario/DNS Secundario",
                    content: "Estos parámetros son asignados automáticamente por el servidor DHCPv6 desde su ISP."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Pulse en este botón para obtener nuevos parámetros IPv6 desde el servidor DHCPv6 del ISP."
                }, {
                    type: "name",
                    title: "Liberar",
                    content: "Pulse en este botón para liberar todas las direcciones IPv6 asignadas por el servidor DHCPv6 desde el ISP."
                }, {
                    type: "name",
                    title: "Obtener Dirección IPv6",
                    content: "Seleccione \"Obtener dirección IPv6 no temporal\" o \"Obtener delegación de prefijo IPv6\", de acuerdo con su ISP."
                }, {
                    type: "name",
                    title: "Dirección DNS",
                    content: "Seleccione \"Obtener dinámicamente desde el ISP\" o \"Usar la dirección DNS siguiente\". Si se selecciona \"Usar la siguiente dirección DNS\", introduzca manualmente la dirección DNS proporcionada por su ISP."
                }, {
                    type: "name",
                    title: "DNS Primario/DNS Secundario",
                    content: "Introduzca estos parámetros de forma manual u obtenga los datos dinamicamente del ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Seleccione este tipo si su ISP utiliza PPPoEv6 y le proporciona un nombre de usuario y una contraseña."
                }, {
                    type: "name",
                    title: "Usuario/Contraseña",
                    content: "Introduzca estos parámetros según lo proporcionado por su ISP."
                }, {
                    type: "name",
                    title: "Dirección IPv6",
                    content: "El servidor DHCPv6 se asignará automáticamente desde el ISP, después de introducir el nombre de usuario y la contraseña y pulsar en Conectar."
                }, {
                    type: "name",
                    title: "Dirección DNS",
                    content: "Seleccione \"Obtener dinámicamente desde el ISP\" o \"Usar la dirección DNS siguiente\". Si se selecciona \"Usar la siguiente dirección DNS\", introduzca manualmente la dirección DNS proporcionada por su ISP."
                }, {
                    type: "name",
                    title: "Obtener Dirección IPv6",
                    content: "Seleccione \"No temporal\" o \"Delegación de prefijo\" o \"Especificado por el ISP\" de acuerdo con su ISP. Si selecciona \"Especificado por el ISP\", deberá introducir manualmente la dirección IPv6 proporcionada por su ISP. Si selecciona \"No temporal\" o \"Delegación de prefijo\", el servidor DHCPv6 asignará automáticamente la dirección IPv6 desde el ISP.",
                    children: [
                        {
                            type: "name",
                            title: "No temporal",
                            content: "Obtenga una dirección IPv6 no temporal del servidor DHCPv6 desde el proveedor de servicios de Internet (ISP)."
                        }, {
                            type: "name",
                            title: "Delegación de Prefijo",
                            content: "Obtenga una dirección IPv6 de delegación de prefijos por DHCPv6 Server desde el ISP y el cliente en LAN crea una dirección IPv6 con la delegación."
                        }, {
                            type: "name",
                            title: "Especificado por ISP",
                            content: "Utilice una dirección IPv6 estática especificada por el ISP."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Conectar",
                    content: "Pulse en este botón para obtener conexión a Internet."
                }, {
                    type: "name",
                    title: "Desconectar",
                    content: "Pulse en este botón para desconectarse de Internet."
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: Túnel 6to4"
                }, {
                    type: "name",
                    title: "Túnel 6to4",
                    content: "Seleccione este tipo si su ISP utiliza la implementación 6to4 para asignar dirección."
                }, {
                    type: "name",
                    title: "Dirección IPv4/Máscara de Subred IPv4/Puerta de Enlace Predeterminada IPv4/ Dirección de Túnel",
                    content: "Estos parámetros serán generados dinámicamente por los parámetros IPv4 del puerto WAN después de pulsar en Conectar."
                }, {
                    type: "name",
                    title: "Usar el siguiente Servidor DNS",
                    content: "Seleccione la casilla para activar esta opción. A continuación, introduzca el DNS principal/DNS secundario proporcionado por su ISP."
                }, {
                    type: "name",
                    title: "Conectar",
                    content: "Pulse en este botón para obtener conexión a Internet."
                }, {
                    type: "name",
                    title: "Desconectar",
                    content: "Pulse en este botón para desconectarse de Internet."
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Seleccione este tipo si su ISP utiliza la implementación 6RD y le proporciona una dirección IPv4 y un prefijo de dirección IPv6."
                }, {
                    type: "name",
                    title: "Tipo de Configuración",
                    content: "Seleccione Automático o Manual para configurar los parámetros del canal 6RD de acuerdo con su ISP. Si los parámetros por defecto de abajo coinciden con los proporcionados por su ISP, puede seleccionar Auto; de lo contrario, seleccione Manual e introduzca los parámetros proporcionados por su ISP."
                }, {
                    type: "name",
                    title: "Longitud de la Máscara IPv4/ Prefijo 6RD/Longitud del Prefijo 6RD/Dirección de Respuesta Límite IPv4",
                    content: "Compruebe si los parámetros preestablecidos coinciden con los proporcionados por su ISP y manténgalos por defecto o introduzcalos manualmente según lo proporcionado por su ISP."
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Seleccione este tipo si su ISP utiliza la implementación de DS-Lite y le proporciona un nombre de dominio AFTR o dirección IPv6 para configurar un túnel IPv4 en IPv6 en la red IPv6 para comunicar tráficos IPv4 o tráfico IPv6 en su propia red respectiva ."
                }, {
                    type: "name",
                    title: "Nombre AFTR",
                    content: "AFTR es la abreviatura de Address Family Transition Router. En este campo, introduzca el nombre de dominio AFTR o dirección IPv6 tal como lo proporciona su ISP."
                }, {
                    type: "name",
                    title: "Conexión Secundaria",
                    content: "Seleccione el tipo de conexión secundaria proporcionado por su ISP.",
                    children: [
                        {
                            type: "name",
                            title: "IP DInámica",
                            content: "Seleccione si su ISP le proporciona IP dinámica como tipo de conexión secundaria y los parámetros Dirección IPv6/DNS principal/DNS secundario serán asignados automáticamente por el servidor DHCPv6 desde su ISP."
                        }, {
                            type: "name",
                            title: "IP Estática",
                            content: "Seleccione este tipo si su ISP utiliza la asignación de dirección IPv6 estática."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Seleccione si su ISP le proporciona PPPoE como tipo de conexión secundaria e introduzca el nombre de usuario/contraseña como lo proporciona su ISP. La dirección IPv6 se asignará automáticamente después de pulsar en Conectar."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexión a Internet: Pass Through (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Seleccione este tipo si su ISP utiliza Pass Through (Bridge). Para este tipo, no se proporcionan parámetros y no se necesitan configuraciones."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Excepto para Pass Through (Bridge), los otros 6 tipos de conexión a Internet requieren configuraciones para los parámetros IPv4 LAN al mismo tiempo."
                }, {
                    type: "name",
                    title: "Tipo Asignado",
                    content: "Seleccione el apropiado según su ISP.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Para asignar automáticamente direcciones IP a los clientes en la LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefijo de Dirección",
                                    content: "Introduzca el prefijo de dirección proporcionado por su ISP."
                                }, {
                                    type: "name",
                                    title: "Tiempo de Liberación",
                                    content: "Significa el tiempo durante el cual la dirección IP asignada permanece válida. Mantenga los 86400 segundos predeterminados o cámbielo si su ISP lo requiere."
                                }, {
                                    type: "name",
                                    title: "Dirección",
                                    content: "Es la dirección IP asignada automáticamente por el servidor DHCPv6 desde el ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "DHCP SLAAC+Stateless",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefijo de Dirección",
                                    content: "Introduzca el prefijo de dirección proporcionado por su ISP."
                                }, {
                                    type: "name",
                                    title: "Dirección",
                                    content: "Es la dirección IP asignada automáticamente por el servidor DHCPv6 desde el ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "SLAAC+RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefijo de Dirección",
                                    content: "Introduzca el prefijo de dirección proporcionado por su ISP."
                                }, {
                                    type: "name",
                                    title: "Dirección",
                                    content: "Es la dirección IP asignada automáticamente por el servidor DHCPv6 desde el ISP."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "Clonado MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Utilizar una Dirección MAC por Defecto",
                    content: "NO cambie la dirección MAC predeterminada del router, en caso de que el ISP no vincule la dirección IP asignada a la dirección MAC."
                }, {
                    type: "name",
                    title: "Utilizar la Dirección MAC del Ordenador Actual",
                    content: "Seleccione para copiar la dirección MAC actual del equipo que está conectado al router, en caso de que el ISP vincule la dirección IP asignada a la dirección MAC del equipo."
                }, {
                    type: "name",
                    title: "Utilizar una Dirección MAC Personalizada",
                    content: "Introduzca la dirección MAC manualmente, en caso de que el ISP vincule la dirección IP asignada a la dirección MAC específica."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Configuración Horaria",
            CONTENT: [
                {
                    type: "step",
                    title: "Para sincronizar automáticamente la hora",
                    content: ["1. Seleccione su <b>Zona Horaria</b> en el menú desplegable.", "2. En el campo <b>NTP Server I</b>, introduzca la dirección IP del servidor NTP deseado. (Opcional)", "3. En el campo <b>Servidor NTP II</b>, introduzca la dirección IP del segundo servidor NTP. (Opcional)", "4. Pulse en <b>Obtener GMT</b>."]
                }, {
                    type: "step",
                    title: "Para configurar manualmente la fecha y la hora",
                    content: ["1. En el campo <b>Configuración Horaria</b>, seleccione su <b>Zona Horaria.</b> ", "2. Introduzca la <b>Fecha</b> actual.", "3. Seleccione la <b>Hora</b> actual (en formato de reloj de 24 horas, por ejemplo, 16:00:00 es 04:00 PM).", "4. Pulse en <b>Guardar</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Horario de Ahorro de Luz",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar el horario de Ahorro de Luz",
                    content: ["1. Seleccione <b> Habilitar Ahorro de Luz</b>.", "2. Seleccione la fecha y hora correctas de <b>Inicio</b> cuando empiece el horario de verano en su zona horaria local.", "3. Seleccione la fecha y hora correctas de <b>Fin</b> cuando finalice el horario de verano en su zona horaria local.", "4. Pulse en <b>Guardar </b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnósticos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El router proporciona herramientas Ping y Traceroute para ayudarle a solucionar problemas de conectividad de red. La herramienta Ping envía paquetes a una dirección IP o nombre de dominio de destino y registra los resultados, como el número de paquetes enviados/recibidos y el tiempo de ida y vuelta. La herramienta Traceroute envía paquetes a una dirección IP o nombre de dominio de destino y muestra el número de saltos y el tiempo para llegar al destino."
                }, {
                    type: "paragraph",
                    content: "Puede hacer ping y traceroute a un dispositivo local mediante la dirección IP o un nombre de dominio, como google.com, yahoo.com, etc."
                }, {
                    type: "step",
                    title: "Para diagnosticar usando Ping",
                    content: ["1. Introduzca la dirección IP o el nombre de dominio de destino.", "2. Pulse en el icono Flecha para abrir el menú Avanzado y especifique el número de ping y el tamaño del paquete de ping. (Opcional)", "3. Pulse en Inicio."]
                }, {
                    type: "step",
                    title: "Para diagnosticar usando Traceroute",
                    content: ["1. Introduzca la dirección IP o el nombre de dominio de destino.", "2. Pulse en el icono Flecha para abrir el menú Avanzado y especifique el número de saltos (a alcanzar) en el campo Traceroute Max TTL (tiempo de vida). El valor predeterminado es 20. (Opcional)", "3. Pulse en Inicio."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Actualicación de Firmware",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Antes de actualizar el firmware del extensor powerline, tendrá que descargar la última actualización de firmware desde el <a class=\"link\" href =\"http://www.tp-link.com/es/support/\"target =\"_blank \">Soporte de TP-LINK</a> a su ordenador."
                }, {
                    type: "step",
                    title: "IMPORTANTE: Para prevenir un fallo en la actualización, por favor tenga en cuenta lo siguiente:",
                    content: ["Asegúrese de que el archivo de firmware más reciente coincide con la versión de hardware (como se muestra en la página Actualización de firmware).", "Asegúrese de que tiene una conexión estable entre el extensor powerline y su ordenador. No se recomienda actualizar el firmware de forma inalámbrica.", "Copia de seguridad de la configuración del extensor powerline.", "NO apague el extensor powerline durante la actualización del firmware."]
                }, {
                    type: "step",
                    title: "Para actualizar el firmware de los extensores powerline",
                    content: ["1. Pulse en <b>Explorar</b>.", "2. Localice y seleccione el archivo de firmware descargado.", "3. Pulse en <b>Actualizar</b>."]
                }, {
                    type: "paragraph",
                    content: "El proceso de actualización tarda unos minutos en completarse. No apague el extensor powerline durante el proceso de actualización."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Para actualizar el firmware online",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Haga click en Actualizar y haga click en Sí cuando aparezca, después el extensor descargará automáticamente el último archivo de firmware y lo actualizará. Puede también hacer click en Comprobar actualizaciones para comprobar la última versión."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Para actualizar el firmware manualmente",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Pulse en Soporte en la parte inferior de la página y descargue el último firmware del equipo. Asegúrese de que el archivo de firmware que va a descargar coincide con la versión de hardware del router tal y como se muestra en la página.", "2. Pulse en Examinar y seleccione el archivo de firmware descargado.", "3. Pulse en Actualizar."]
                }, {
                    type: "paragraph",
                    content: ["Se requieren unos minutos para completar la actualización de firmware. El extensor se reiniciará automáticamente cuando la actualización de firmware haya finalizado."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Copia de Seguridad",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Es muy recomendable realizar una copia de seguridad de las configuraciones actuales, en caso de que sea necesaria una recuperación para restaurar el sistema a un estado anterior o a los valores predeterminados de fábrica."
                }, {
                    type: "paragraph",
                    content: "Pulse en <b>Copia de Seguridad</b> para guardar las configuraciones actuales en el equipo. Asegúrese de guardar el archivo de copia de seguridad en una ubicación segura que puede recuperar y restaurar el extensor más adelante, si es necesario."
                }
            ]
        },
        RESTORE: {
            TITLE: "Restaurar",
            CONTENT: [
                {
                    type: "step",
                    title: "Para restaurara desde una copia de seguridad",
                    content: ["1. Haga clic en <b>Explorar </b>.", "2. Busque y seleccione el archivo de copia de seguridad.", "3. Haga clic en <b>Restaurar </b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Restaurar Ajustes de Fábrica",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Pulse en <b>Restauración de fábrica</b> para restablecer su extensor powerline a sus valores predeterminados de fábrica."
                }, {
                    type: "note",
                    title: "Nota",
                    content: ["1. El Reset de Fábrica borrará todos los ajustes que haya configurado en el extensor powerline. Para volver a acceder a la página de gestión del extensor, utilice por defecto <b>admin</b>tanto para nombre de usuario como para contraseña.", "2. Por favor NO apague el extensor durante el proceso de backup o de restauración."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Cuenta de Gestión",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta página le permite cambiar su nombre de usuario y/o contraseña."
                }, {
                    type: "name",
                    title: "Usuario Antiguo",
                    content: "Escriba su nombre de usuario actual."
                }, {
                    type: "name",
                    title: "Contraseña Antigua",
                    content: "Escriba su contraseña actual."
                }, {
                    type: "name",
                    title: "Nuevo Usuario",
                    content: "Escriba su nuevo nombre de usuario."
                }, {
                    type: "name",
                    title: "Nueva Contraseña",
                    content: "Escriba su nueva contraseña."
                }, {
                    type: "name",
                    title: "Confirmar Nueva Contraseña",
                    content: "Escriba su nueva contraseña de nuevo."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si cambia el nombre de usuario y la contraseña actuales utilizados para iniciar sesión en el extensor powerline, asegúrese de que la nueva información de inicio de sesión esté escrita en una ubicación segura. Una contraseña segura debe tener al menos 8 o más caracteres de longitud, combinando letras mayúsculas y minúsculas, números y signos de puntuación."
                }, {
                    type: "paragraph",
                    content: "Pulse en <b>Guardar</b> para guardar todos los ajustes."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Recuperar Contraseña",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Recuperación de Contraseña",
                    content: "Se recomienda que habilite la función Recuperación de contraseña, que le enviará su nombre de usuario olvidado y su contraseña por correo electrónico."
                }, {
                    type: "name",
                    title: "Desde",
                    content: "Introduzca la dirección de correo electrónico válida que se utilizará para el correo electrónico saliente."
                }, {
                    type: "name",
                    title: "Hasta",
                    content: "Introduzca la dirección de correo electrónico válida que se utilizará para el correo electrónico entrante."
                }, {
                    type: "name",
                    title: "Servidor SMTP",
                    content: "Introduzca la dirección del servidor SMTP que utiliza el router para enviar la información de la cuenta por correo electrónico."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "  Seleccione Habilitar autentificación si el servidor de correo saliente requiere autentificación para enviar correo electrónico y llene el nombre de usuario y la contraseña en los campos correspondientes. Estos campos distinguen entre mayúsculas y minúsculas."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Gestión Local",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta sección le permite limitar el número de dispositivos cliente en su LAN de acceder al router mediante la autentificación basada en direcciones MAC."
                }, {
                    type: "name",
                    title: "Acceso para Todos los Dispositivos Conectados en LAN",
                    content: "Activar para habilitar la administración local de todos los dispositivos conectados LAN o Desactivar para habilitar la administración de un dispositivo específico."
                }, {
                    type: "name",
                    title: "Diracción MAC",
                    content: "Muestra la dirección MAC del dispositivo de acceso limitado."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra la descripción del dispositivo de acceso limitado."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual del dispositivo de acceso limitado (habilitado o deshabilitado)."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones de Modificar y Eliminar el dispositivo correspondiente de la lista."
                }, {
                    type: "step",
                    title: "Para añadir un dispositivo cliene a la lista",
                    content: ["1. Haga clic en Agregar.", "2. Haga clic en Ver dispositivos existentes para elegir un dispositivo existente o introduzca la dirección MAC de un dispositivo en el campo Dirección MAC.", "3. Introduzca una descripción para el dispositivo. (Opcional)", "4. Seleccione Habilitar.", "5. Haga clic en Aceptar."]
                }, {
                    type: "step",
                    title: "Para modificar o borrar un dispositivo en la lista",
                    content: "Haga clic en el icono Modificar o en el icono Eliminar que corresponde al dispositivo que desea modificar o eliminar."
                }, {
                    type: "step",
                    title: "Para borrar múltiples dispositivos",
                    content: "Seleccione todos los dispositivos que desea eliminar, haga clic en Eliminar."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Gestión Remota",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La función de administración remota le permite acceder y configurar el router remotamente desde Internet."
                }, {
                    type: "name",
                    title: "Deshabilitar Gestión Remota",
                    content: "Seleccione esta opción para deshabilitar la administración remota."
                }, {
                    type: "name",
                    title: "Habilitar Gestión remota para Todos los Dispositivos",
                    content: "Seleccione esta opción para habilitar la administración remota de todas las direcciones IP. Si está seleccionado, ingrese el campo Puerto de administración web."
                }, {
                    type: "name",
                    title: "Habilitar Gestión Remota para Dispositivos Específicos",
                    content: "Seleccione esta opción para habilitar la administración remota para una dirección IP específica. Si está seleccionado, ingrese los campos Dirección Web y Dirección IP de Administración Remota."
                }, {
                    type: "name",
                    title: "Puerto de Gestión Web",
                    content: "Introduzca el número de puerto, entre 1024 y 65535, que se utiliza para acceder a la interfaz de administración web del router con mayor seguridad. Normalmente, los navegadores web utilizan el puerto de servicio HTTP estándar 80. El puerto de servicio predeterminado y común es 8080, que es un puerto de servicio alternativo del HTTP."
                }, {
                    type: "name",
                    title: "Dirección IP de Gestión Remota",
                    content: "Ingrese una dirección IP válida o rango de IP para poder acceder al router. Si se introduce 255.255.255.255, se permite a todos el acceso."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Registro del Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página Registro del sistema muestra una lista de las actividades (eventos) más recientes del extensor. Puede definir los tipos de registros y / o el nivel de registros que desea ver."
                }, {
                    type: "name",
                    title: "Tipo",
                    content: "Seleccione el tipo de registro del sistema que se mostrará."
                }, {
                    type: "name",
                    title: "Nivel ",
                    content: "Seleccione el nivel del registro del sistema que se mostrará."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Haga clic en este icono para actualizar el registro del sistema."
                }, {
                    type: "name",
                    title: "Borrar Todo",
                    content: "Haga clic en este icono para eliminar todos los registros del sistema."
                }, {
                    type: "name",
                    title: "Guardar Log",
                    content: "Haga clic en este botón para descargar el archivo de registro del sistema en su ordenador local."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Estadísticas de Tráfico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página Estadísticas de tráfico muestra el tráfico de red de los envíos y devoluciones de paquetes LAN, WAN y WLAN."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si NAT Boost está habilitado, las estadísticas de tráfico deben estar deshabilitadas."
                }, {
                    type: "name",
                    title: "Estadísticas de Tráfico",
                    content: "De forma predeterminada, las estadísticas de tráfico están desactivadas. Para mostrar la información estadística, haga clic en Activado."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Lista de Estadísticas de Tráfico",
            CONTENT: [
                {
                    type: "name",
                    title: "Dirección IP/Dirección MAC",
                    content: "Muestra la dirección IP y la dirección MAC del dispositivo cliente asociado."
                }, {
                    type: "name",
                    title: "Pquetes Totales",
                    content: "Muestra el número total de paquetes transmitidos y recibidos por el dispositivo cliente desde el inicio de la sesión o el último restablecimiento del contador."
                }, {
                    type: "name",
                    title: "Bytes Totales",
                    content: "Muestra el número total de bytes transmitidos y recibidos por el dispositivo cliente desde el comienzo de la sesión o el último restablecimiento del contador."
                }, {
                    type: "name",
                    title: "Paquetes Actuales",
                    content: "Muestra el número actual de paquetes transmitidos y recibidos en un intervalo de tiempo específico."
                }, {
                    type: "name",
                    title: "Bytes Actuales",
                    content: "Muestra el número actual de bytes transmitidos y recibidos en un intervalo de tiempo específico."
                }, {
                    type: "name",
                    title: "ICMP Tx Actual",
                    content: "Muestra la velocidad de transmisión actual y la velocidad de transmisión máxima de los paquetes ICMP transmitidos a través del puerto WAN por segundo."
                }, {
                    type: "name",
                    title: "UDP TX Actual",
                    content: "Muestra la velocidad de transmisión actual y la velocidad máxima de transmisión de paquetes UDP transmitidos a través del puerto WAN por segundo."
                }, {
                    type: "name",
                    title: "SYN Tx Actual",
                    content: "Muestra la velocidad de transmisión actual y la velocidad de transmisión máxima de los paquetes TCP SYN transmitidos a través del puerto WAN por segundo."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones de Reset (a cero) y elimina la estadística correspondiente de la lista."
                }, {
                    type: "name",
                    title: "Actualizar",
                    content: "Haga clic para actualizar la información estadística de la página."
                }, {
                    type: "name",
                    title: "Resetear Todo",
                    content: "Haga clic para restablecer todos los valores estadísticos de la lista a cero."
                }, {
                    type: "name",
                    title: "Borrar Todo",
                    content: "Haga clic para eliminar toda la información estadística de la lista."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "Wi-Fi 2.4GHz/5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Intervalo Beacon",
                    content: "Introduzca un valor entre 40 y 1000 en milisegundos para determinar la duración entre los paquetes de baliza que se emiten por el router para sincronizar la red inalámbrica. El valor predeterminado es 100 milisegundos."
                }, {
                    type: "name",
                    title: "RTS Threshold",
                    content: "Introduzca un valor entre 1 y 2346 para determinar el tamaño de paquete de transmisión de datos a través del router. De forma predeterminada, el tamaño del umbral RTS (solicitud de envío) es 2346. Si el tamaño del paquete es mayor que el umbral preestablecido, el router envía solicitudes de envío de tramas a una estación receptora particular y negocia el envío de un marco de datos, o bien el paquete será enviado inmediatamente."
                }, {
                    type: "name",
                    title: "Intervalo DTIM",
                    content: "Este valor determina el intervalo del mensaje de indicación de tráfico de entrega (DTIM). Introduzca un valor entre 1 y 15 en milisegundos. El valor predeterminado es 1, indica que el Intervalo DTIM es el mismo que el Intervalo Beacon."
                }, {
                    type: "name",
                    title: "Período de Actualización de Clave de Grupo",
                    content: "Introduzca el número de segundos (mínimo 30) para controlar el intervalo de tiempo para la renovación automática de la clave de cifrado. El valor predeterminado es 0, indicando que no hay renovación de clave."
                }, {
                    type: "name",
                    title: "Característica WMM",
                    content: "La función WMM garantiza los paquetes con mensajes de alta prioridad que se transmiten preferentemente. Está habilitado por defecto y altamente recomendado."
                }, {
                    type: "name",
                    title: "Función Short GI",
                    content: "Esta función está activada de forma predeterminada y se recomienda aumentar la capacidad de datos reduciendo el tiempo de intervalo de protección (GI)."
                }, {
                    type: "name",
                    title: "Característica de Aislamiento de AP",
                    content: "De forma predeterminada, esta función está deshabilitada. Si desea restringir todos los dispositivos inalámbricos conectados a su red, pero aún puede acceder a Internet, seleccione la casilla Habilitar aislamiento de AP."
                }, {
                    type: "name",
                    title: "WDS Bridging",
                    content: "Active la función Bridging WDS (Sistema de distribución inalámbrica) para permitir que el router enlace con otro punto de acceso (AP) en una red de área local inalámbrica (WLAN). Si esta función está habilitada, configure lo siguiente:",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Introduzca el SSID del punto de acceso inalámbrico (WAP) al que el router se conectará como cliente o utilice la función Survey para encontrar todas las redes disponibles en el canal actual."
                        }, {
                            type: "name",
                            title: "Encuesta",
                            content: "Haga clic en este botón para explorar y mostrar el SSID, BSSID, intensidad de señal, canal e información de seguridad de todas las redes inalámbricas disponibles dentro del alcance. Una vez que seleccione una red, el SSID, la dirección MAC y la seguridad se rellenarán automáticamente."
                        }, {
                            type: "name",
                            title: "Dirección MAC (a conectarse)",
                            content: "Introduzca la dirección MAC (BSSID) en 12 caracteres hexadecimales (0-9, a-f, A-F) separados por guiones del punto de acceso inalámbrico al que el router se conectará como cliente. Si elige el AP deseado a través de la función Survey, el campo Dirección MAC se rellena automáticamente."
                        }, {
                            type: "name",
                            title: "Seguridad",
                            content: "Seleccione el tipo de seguridad correcto del punto de acceso seleccionado, No, WPA-PSK / WPA2-PSK o WEP. Si elige el AP deseado a través de la función Survey, el campo Seguridad se rellena automáticamente.",
                            children: [
                                {
                                    type: "name",
                                    title: "Contraseña",
                                    content: "Esta opción está disponible cuando el tipo de seguridad es WPA-PSK / WPA2-PSK o WEP. Introduzca la contraseña de seguridad del punto de acceso seleccionado."
                                }, {
                                    type: "name",
                                    title: "Tipo de Autenticación",
                                    content: "Esta opción sólo está disponible cuando el tipo de seguridad es WEP (Wired Equivalent Privacy). Seleccione el tipo de autentificación apropiado (Auto, Sistema abierto o clave compartida) utilizado del punto de acceso seleccionado."
                                }, {
                                    type: "name",
                                    title: "Formato de Clave WEP",
                                    content: "Esta opción sólo está disponible cuando el tipo de seguridad es WEP. Seleccione el formato de clave (ASCII o hexadecimal) utilizado del AP seleccionado."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Haga clic en Guardar para guardar la configuración."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccione la casilla Habilitar WPS y haga clic en Guardar para activar la función WPS (Wi-Fi Protected Setup) que le permite configurar y conectar fácilmente los dispositivos habilitados para WPS solo pulsando un botón."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Seleccione la casilla de verificación Activar NAT y haga clic en Guardar para habilitar la función NAT (Traducción de direcciones de red)."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Seleccione la casilla de verificación Habilitar NAT Boost y haga clic en Guardar para asegurarse de que el router tiene el mejor rendimiento."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "NAT Boost se deshabilitará cuando se active QoS o Estadísticas de tráfico."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "Ajustes de Nivel de Protección DoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "El nivel de protección DoS protege el router de los ataques TCP-SYN-Flood, UDP-Flood e ICMP-Flood."
                }, {
                    type: "name",
                    title: "Nivel de Paquetes ICMP-FLOOD",
                    content: "Introduzca un valor entre 5 y 7200 paquetes ICMP para activar la protección ICMP-FLOOD inmediatamente cuando el número de paquetes exceda el valor umbral preestablecido."
                }, {
                    type: "name",
                    title: "Nivel de Paquetes UDP-FLOOD",
                    content: "Introduzca un valor entre 5 y 7200 paquetes UDP para activar la protección UDP-FLOOD inmediatamente cuando el número de paquetes exceda el valor umbral preestablecido."
                }, {
                    type: "name",
                    title: "Nivel de Paquetes TCP-FLOOD",
                    content: "Introduzca un valor entre 5 y 7200 paquetes TCP-SYN para activar la protección TCP-SYN-FLOOD inmediatamente cuando el número de paquetes exceda el valor umbral preestablecido."
                }, {
                    type: "paragraph",
                    content: "Haga clic en Guardar para guardar la configuración."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Dúplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Seleccione el tipo dúplex en la lista desplegable."
                }, {
                    type: "paragraph",
                    content: "Haga clic en Guardar para guardar la configuración."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Intenet",
            CONTENT: [
                {
                    type: "name",
                    title: "Estado de Internet",
                    content: "Muestra el estado actual de la conexión a Internet del router."
                }, {
                    type: "name",
                    title: "Tipo de Conexión",
                    content: "Muestra el tipo de conexión a Internet."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP de Internet actual asignada al router."
                }, {
                    type: "name",
                    title: "Conexión Secundaria / Dirección IP",
                    content: "Muestra el tipo de conexión secundaria y la dirección IP."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Router",
            CONTENT: [
                {
                    type: "title",
                    title: "Wi-Fi 2,4GHz/5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Muestra el nombre de red inalámbrica actual de la frecuencia de 2.4 GHz / 5 GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Muestra el canal del cual transmite la red inalámbrica de 2.4 GHz / 5 GHz."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "Muestra la dirección MAC actual de los 2.4GHz / 5GHz inalámbricos."
                }, {
                    type: "title",
                    title: "Radio Inalámbrica 2,4GHz/5GHz"
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra si la Red de invitados inalámbrica 2.4GHz / 5GHz está activada (habilitada) o desactivada (deshabilitada)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Muestra el nombre de red inalámbrica de Guest Network."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Clientes Cableados/Inalámbricos",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre",
                    content: "Muestra el nombre del cliente conectado al router."
                }, {
                    type: "name",
                    title: "Dirección IP",
                    content: "Muestra la dirección IP asignada del cliente."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC del cliente."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Impresora",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre",
                    content: "Muestra el nombre de la impresora conectada al router a través del puerto USB."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "Disco USB",
            CONTENT: [
                {
                    type: "name",
                    title: "Disco USB",
                    content: "Muestra la marca del disco USB conectado al router."
                }, {
                    type: "name",
                    title: "Total",
                    content: "Muestra el volumen total del disco USB."
                }, {
                    type: "name",
                    title: "Disponible",
                    content: "Muestra el espacio disponible del disco USB."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Detectar Automáticamente",
                    content: "Haga clic en este botón para que el router detecte automáticamente su tipo de conexión a Internet actual."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Si no está seguro de qué tipo de conexión a Internet tiene, utilice la función Detección automática o póngase en contacto con su ISP para obtener ayuda."
                }, {
                    type: "title",
                    title: "Tipo de conexión a Internet: IP estática"
                }, {
                    type: "name",
                    title: "Dirección IP / Máscara de subred / Puerta de enlace predeterminada / DNS principal / DNS secundario",
                    content: "Introduzca la información proporcionada por su ISP."
                }, {
                    type: "title",
                    title: "Tipo de conexión a Internet: IP dinámica"
                }, {
                    type: "name",
                    title: "NO clonar la dirección MAC / Clonar la dirección MAC del ordenador actual",
                    content: "Seleccione si desea clonar su dirección MAC o no, de acuerdo con su ISP."
                }, {
                    type: "title",
                    title: "Tipo de conexión a Internet: PPPoE"
                }, {
                    type: "name",
                    title: "Usuario / Contraseña",
                    content: "Introduzca el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "title",
                    title: "Tipo de conexión a Internet: L2TP / PPTP"
                }, {
                    type: "name",
                    title: "Usuario / Contraseña",
                    content: "Introduzca el nombre de usuario y la contraseña proporcionados por su ISP. Estos campos distinguen entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Conexión Secundaria (IP dinámica o IP estática)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinámica",
                            content: "Seleccione si la dirección IP y la Máscara de subred son asignadas automáticamente por el ISP."
                        }, {
                            type: "name",
                            title: "IP Estática",
                            content: "  Seleccione si la dirección IP, la Máscara de subred, la Puerta de enlace y las direcciones de DNS son proporcionadas por el ISP e introduzca esta información en los campos correspondientes."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP del Servidor VPN / Nombre de Dominio",
                    content: "Introduzca la dirección IP o el nombre de dominio del servidor VPN proporcionado por su ISP."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "Ajustes Inalámbricos",
            CONTENT: [
                {
                    type: "name",
                    title: "Activar Radio Inalámbrica",
                    content: "Seleccione esta casilla de verificación para activar la frecuencia de radio inalámbrica de 2.4 GHz / 5 GHz."
                }, {
                    type: "name",
                    title: "Nombre de Red Inalámbrica (SSID)",
                    content: "Puede dejar el nombre de red inalámbrica predeterminado (SSID) tal cual o introducir un nombre nuevo (hasta 32 caracteres). Este campo distingue entre mayúsculas y minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccione esta casilla de verificación si desea ocultar el nombre de red (SSID) de 2.4 GHz / 5 GHz de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Introduzca una contraseña inalámbrica entre 8 y 63 caracteres ASCII o entre 8 y 64 caracteres hexadecimales en este campo ( Distingue entre mayúsculas y minúsculas)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Ajustes del Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La página de Configuración del dispositivo muestra la información relacionada con cualquier dispositivo de almacenamiento USB conectado a través del puerto USB."
                }, {
                    type: "name",
                    title: "Escanear",
                    content: "Por lo general, el router detecta automáticamente cualquier dispositivo recién conectado. Si no, haga clic en este botón para buscar cualquier dispositivo nuevo conectado y actualice la página con la información actualizada."
                }, {
                    type: "name",
                    title: "Volumen",
                    content: "Muestra el nombre del volumen USB."
                }, {
                    type: "name",
                    title: "Capacidad",
                    content: "Muestra la capacidad total de almacenamiento USB."
                }, {
                    type: "name",
                    title: "Espacio Libre",
                    content: "Muestra el espacio de almacenamiento libre disponible actual."
                }, {
                    type: "name",
                    title: "Retirar con Cuidado",
                    content: "Haga clic en este botón para desconectar con seguridad el dispositivo de almacenamiento USB antes de desconectarlo físicamente del router.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Tenga en cuenta que el botón Quitar de forma segura sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router. Además, tenga en cuenta que no puede desconectar el dispositivo USB mientras el volumen actual está ocupado."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Activo",
                    content: "Esta casilla de verificación sólo aparece cuando hay un dispositivo de almacenamiento USB conectado al router. Seleccione esta opción para habilitar el uso compartido de archivos del dispositivo USB."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Ajustes de Uso Compartido",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre del Servidor de Red / Multimedia",
                    content: "Muestra el nombre utilizado para acceder al dispositivo de almacenamiento USB conectado."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Carpeta Comaprtida",
            CONTENT: [
                {
                    type: "name",
                    title: "Compartir Todo",
                    content: "Seleccione ON para compartir todos los archivos y carpetas u Off para compartir únicamente las carpetas seleccionadas."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Se recomienda habilitar la autenticación para requerir que los usuarios introduzcan un nombre de usuario y una contraseña válidos para acceder a las carpetas de uso compartido."
                }, {
                    type: "name",
                    title: "Nombre de la Carpeta",
                    content: "Muestra el nombre de la carpeta compartida."
                }, {
                    type: "name",
                    title: "Ruta de la Carpeta",
                    content: "Muestra la ruta de la carpeta compartida."
                }, {
                    type: "name",
                    title: "Compartición Multimedia",
                    content: "Indica si la carpeta compartida está permitida para compartir multimedia o no."
                }, {
                    type: "name",
                    title: "Nombre del Volumen",
                    content: "Muestra el nombre del volumen compartido."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado de la carpeta compartida mediante el indicador de la bombilla. Verde (ON) está activado y Gris (OFF) está desactivado. Puede habilitar o deshabilitar el uso compartido haciendo clic en la bombilla."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar y Eliminar la carpeta compartida correspondiente."
                }, {
                    type: "name",
                    title: "Añadir",
                    content: "Haga clic en este botón para crear una entrada nueva."
                }, {
                    type: "name",
                    title: "Eliminar",
                    content: "Haga clic en este botón para quitar la entrada seleccionada de la tabla."
                }, {
                    type: "name",
                    title: "Mostrar",
                    content: "Haga clic en para buscar una carpeta compartida."
                }, {
                    type: "name",
                    title: "Permitir Acceso a la Red de Invitados",
                    content: "Seleccione esta opción para permitir que los clientes de la red de invitados accedan a las carpetas compartidas."
                }, {
                    type: "name",
                    title: "Habilitar Autenticación",
                    content: "Seleccione para que los usuarios tengan acceso a las carpetas compartidas con un nombre de usuario y una contraseña válidos."
                }, {
                    type: "name",
                    title: "Habilitar Acceso de Escritura",
                    content: "Seleccione esta opción para permitir a los usuarios realizar cambios en el contenido de la carpeta."
                }, {
                    type: "name",
                    title: "Habilitar la Compartición Multimedia",
                    content: "Seleccione esta opción para habilitar el uso compartido de medios."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Servidor de Impresión",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Servidor de Impresión",
                    content: "Haga clic en ON para activar la función del servidor de impresión."
                }, {
                    type: "name",
                    title: "Nombre de la Impresora",
                    content: "Muestra el nombre de la impresora conectada al router."
                }, {
                    type: "step",
                    title: "Configurar un Servidor de Impresión para toda la red",
                    content: ["1. Conecte una impresora USB al puerto USB del router a través de un cable USB.", "2. Instale el controlador de la impresora en su ordenador, consulte los manuales del fabricante del ordenador para obtener instrucciones.", "3. Instale la Utilidad del controlador de impresora USB TP-LINK desde el CD de recursos (sólo para Windows) o descargue (para Windows y Mac OS X) desde el sitio web oficial de TP-LINK."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Control Parental",
            CONTENT: [
                {
                    type: "name",
                    title: "Estado",
                    content: "Toggle on para activar la función de control parental. De forma predeterminada, esta función está deshabilitada."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Dispositivos bajo Control Parental",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Muestra la lista de dispositivos bajo Control parental."
                }, {
                    type: "name",
                    title: "Nombre del Dispositivo",
                    content: "Muestra el nombre de todos los dispositivos cliente que están actualmente  conectados bajo Control parental."
                }, {
                    type: "name",
                    title: "Dirección MAC",
                    content: "Muestra la dirección MAC de todos los dispositivos cliente que están actualmente conectados bajo control parental."
                }, {
                    type: "name",
                    title: "Tiempo de Acceso a Internet",
                    content: "Muestra los períodos de tiempo de acceso restringido."
                }, {
                    type: "name",
                    title: "Descripción",
                    content: "Muestra una breve descripción del dispositivo conectado. Es un ajuste opcional."
                }, {
                    type: "name",
                    title: "Estado",
                    content: "Muestra el estado actual (activado o desactivado) del control parental del dispositivo correspondiente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Muestra las opciones para Modificar o Eliminar el dispositivo correspondiente."
                }, {
                    type: "step",
                    title: "Para restringir un nuevo dispositivo cliente",
                    content: [
                        "1. Haga clic en Agregar.",
                        "2. Haga clic en Ver dispositivos existentes y elija un dispositivo actualmente conectado en la Lista de dispositivos de acceso o introduzca el Nombre del dispositivo y la Dirección MAC manualmente para agregar un dispositivo que no esté conectado.",
                        "3. Haga clic en el icono Tiempo de acceso a Internet para especificar un período de tiempo durante el cual se aplica la restricción.",
                        "4. Introduzca una breve descripción en el campo Descripción. (Opcional)",
                        "5. Seleccione Habilitar.",
                        "6. Haga clic en Aceptar para guardar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar o eliminar una entrada de Control Parental, simplemente haga clic en el icono Modificar para editar la información o en el icono Eliminar para eliminar la entrada correspondiente."
                }, {
                    type: "paragraph",
                    content: "Para eliminar varias entradas, seleccione todas las entradas y haga clic en Eliminar en la parte superior de la tabla."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Red de Invitados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La red de invitados le permite configurar una red independiente con un nombre de red  (SSID) y una contraseña distinta que los invitados pueden utilizar para acceder a su red inalámbrica."
                }, {
                    type: "name",
                    title: "Permite que los invitados se vean",
                    content: "Seleccione esta casilla de verificación para permitir que los dispositivos inalámbricos de la Red de invitados se vean entre sí."
                }, {
                    type: "name",
                    title: "No permite que los invitados administren mi red.",
                    content: "Seleccione esta opción para evitar que los invitados se conecten a las interfaces de administración web."
                }, {
                    type: "name",
                    title: "Habilitar Red de Invitados",
                    content: "Seleccione esta casilla de verificación para activar la función de red de invitados de 2,4 GHz / 5 GHz."
                }, {
                    type: "name",
                    title: "Nombre de Red Inalámbrica (SSID)",
                    content: "Utilice el SSID invitado predeterminado o cree un nuevo nombre (hasta 32 caracteres)."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Seleccione esta casilla de verificación si desea ocultar el SSID invitado de la lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Contraseña",
                    content: "Cree una contraseña entre 8 y 63 caracteres ASCII, o entre 8 y 64 caracteres hexadecimales (0-9, a-f, A-F), para asegurar la red de invitados."
                }
            ]
        },
        "": ""
    };
})(jQuery);
